/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.test.implementation.faultinjection;

import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.faultinjection.FaultInjectionRequestArgs;
import com.azure.cosmos.implementation.faultinjection.IServerErrorInjector;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.test.implementation.faultinjection.FaultInjectionRuleStore;
import com.azure.cosmos.test.implementation.faultinjection.FaultInjectionServerErrorRule;
import java.time.Duration;

public class ServerErrorInjector
implements IServerErrorInjector {
    private final FaultInjectionRuleStore ruleStore;

    public ServerErrorInjector(FaultInjectionRuleStore ruleStore) {
        Preconditions.checkNotNull((Object)ruleStore, (Object)"Argument 'ruleStore' can not be null");
        this.ruleStore = ruleStore;
    }

    public boolean injectServerResponseDelayBeforeProcessing(FaultInjectionRequestArgs faultInjectionRequestArgs, Utils.ValueHolder<Duration> injectedDelay) {
        FaultInjectionServerErrorRule serverResponseDelayRule = this.ruleStore.findServerResponseDelayRule(faultInjectionRequestArgs);
        if (serverResponseDelayRule != null) {
            if (serverResponseDelayRule.getResult() != null && serverResponseDelayRule.getResult().getSuppressServiceRequests() != null && !serverResponseDelayRule.getResult().getSuppressServiceRequests().booleanValue()) {
                return false;
            }
            faultInjectionRequestArgs.getServiceRequest().faultInjectionRequestContext.applyFaultInjectionRule(faultInjectionRequestArgs.getTransportRequestId(), serverResponseDelayRule.getId());
            injectedDelay.v = serverResponseDelayRule.getResult().getDelay();
            return true;
        }
        return false;
    }

    public boolean injectServerResponseDelayAfterProcessing(FaultInjectionRequestArgs faultInjectionRequestArgs, Utils.ValueHolder<Duration> injectedDelay) {
        FaultInjectionServerErrorRule serverResponseDelayRule = this.ruleStore.findServerResponseDelayRule(faultInjectionRequestArgs);
        if (serverResponseDelayRule != null) {
            if (serverResponseDelayRule.getResult() == null || serverResponseDelayRule.getResult().getSuppressServiceRequests() == null || serverResponseDelayRule.getResult().getSuppressServiceRequests().booleanValue()) {
                return false;
            }
            faultInjectionRequestArgs.getServiceRequest().faultInjectionRequestContext.applyFaultInjectionRule(faultInjectionRequestArgs.getTransportRequestId(), serverResponseDelayRule.getId());
            injectedDelay.v = serverResponseDelayRule.getResult().getDelay();
            return true;
        }
        return false;
    }

    public boolean injectServerResponseError(FaultInjectionRequestArgs faultInjectionRequestArgs, Utils.ValueHolder<CosmosException> injectedException) {
        FaultInjectionServerErrorRule serverResponseErrorRule = this.ruleStore.findServerResponseErrorRule(faultInjectionRequestArgs);
        if (serverResponseErrorRule != null) {
            faultInjectionRequestArgs.getServiceRequest().faultInjectionRequestContext.applyFaultInjectionRule(faultInjectionRequestArgs.getTransportRequestId(), serverResponseErrorRule.getId());
            CosmosException cause = serverResponseErrorRule.getInjectedServerError(faultInjectionRequestArgs.getServiceRequest());
            injectedException.v = cause;
            return true;
        }
        return false;
    }

    public boolean injectServerConnectionDelay(FaultInjectionRequestArgs faultInjectionRequestArgs, Utils.ValueHolder<Duration> injectedDelay) {
        if (faultInjectionRequestArgs == null) {
            return false;
        }
        FaultInjectionServerErrorRule serverConnectionDelayRule = this.ruleStore.findServerConnectionDelayRule(faultInjectionRequestArgs);
        if (serverConnectionDelayRule != null) {
            faultInjectionRequestArgs.getServiceRequest().faultInjectionRequestContext.applyFaultInjectionRule(faultInjectionRequestArgs.getTransportRequestId(), serverConnectionDelayRule.getId());
            injectedDelay.v = serverConnectionDelayRule.getResult().getDelay();
            return true;
        }
        return false;
    }
}

