/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.ConnectionMode;
import com.azure.cosmos.CosmosClientException;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.directconnectivity.DirectBridgeInternal;
import com.azure.cosmos.implementation.directconnectivity.StoreResponse;
import com.azure.cosmos.implementation.directconnectivity.StoreResult;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

class ClientSideRequestStatistics {
    private static final int MAX_SUPPLEMENTAL_REQUESTS_FOR_TO_STRING = 10;
    private static final DateTimeFormatter RESPONSE_TIME_FORMATTER = DateTimeFormatter.ofPattern("dd MMM yyyy HH:mm:ss.SSS").withLocale(Locale.US);
    private static final OperatingSystemMXBean mbean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
    private final ZonedDateTime requestStartTime = ZonedDateTime.now(ZoneOffset.UTC);
    private ZonedDateTime requestEndTime = ZonedDateTime.now(ZoneOffset.UTC);
    private ConnectionMode connectionMode;
    private final List<StoreResponseStatistics> responseStatisticsList = new ArrayList<StoreResponseStatistics>();
    private final List<StoreResponseStatistics> supplementalResponseStatisticsList = new ArrayList<StoreResponseStatistics>();
    private final Map<String, AddressResolutionStatistics> addressResolutionStatistics = new HashMap<String, AddressResolutionStatistics>();
    private GatewayStatistic gatewayStatistic;
    private List<URI> contactedReplicas = new ArrayList<URI>();
    private Set<URI> failedReplicas = new HashSet<URI>();
    private Set<URI> regionsContacted = new HashSet<URI>();

    ClientSideRequestStatistics() {
        this.connectionMode = ConnectionMode.DIRECT;
    }

    Duration getRequestLatency() {
        return Duration.between(this.requestStartTime, this.requestEndTime);
    }

    private boolean isCPUOverloaded() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recordResponse(RxDocumentServiceRequest request, StoreResult storeResult) {
        ZonedDateTime responseTime = ZonedDateTime.now(ZoneOffset.UTC);
        this.connectionMode = ConnectionMode.DIRECT;
        StoreResponseStatistics storeResponseStatistics = new StoreResponseStatistics();
        storeResponseStatistics.requestResponseTime = responseTime;
        storeResponseStatistics.storeResult = storeResult;
        storeResponseStatistics.requestOperationType = request.getOperationType();
        storeResponseStatistics.requestResourceType = request.getResourceType();
        URI locationEndPoint = null;
        if (request.requestContext.locationEndpointToRoute != null) {
            locationEndPoint = request.requestContext.locationEndpointToRoute;
        }
        ClientSideRequestStatistics clientSideRequestStatistics = this;
        synchronized (clientSideRequestStatistics) {
            if (responseTime.isAfter(this.requestEndTime)) {
                this.requestEndTime = responseTime;
            }
            if (locationEndPoint != null) {
                this.regionsContacted.add(locationEndPoint);
            }
            if (storeResponseStatistics.requestOperationType == OperationType.Head || storeResponseStatistics.requestOperationType == OperationType.HeadFeed) {
                this.supplementalResponseStatisticsList.add(storeResponseStatistics);
            } else {
                this.responseStatisticsList.add(storeResponseStatistics);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recordGatewayResponse(RxDocumentServiceRequest rxDocumentServiceRequest, StoreResponse storeResponse, CosmosClientException exception) {
        ZonedDateTime responseTime = ZonedDateTime.now(ZoneOffset.UTC);
        this.connectionMode = ConnectionMode.GATEWAY;
        ClientSideRequestStatistics clientSideRequestStatistics = this;
        synchronized (clientSideRequestStatistics) {
            if (responseTime.isAfter(this.requestEndTime)) {
                this.requestEndTime = responseTime;
            }
            this.gatewayStatistic = new GatewayStatistic();
            this.gatewayStatistic.operationType = rxDocumentServiceRequest.getOperationType();
            if (storeResponse != null) {
                this.gatewayStatistic.statusCode = storeResponse.getStatus();
                this.gatewayStatistic.subStatusCode = DirectBridgeInternal.getSubStatusCode(storeResponse);
                this.gatewayStatistic.sessionToken = storeResponse.getHeaderValue("x-ms-session-token");
                this.gatewayStatistic.requestCharge = storeResponse.getHeaderValue("x-ms-request-charge");
            } else if (exception != null) {
                this.gatewayStatistic.statusCode = exception.getStatusCode();
                this.gatewayStatistic.subStatusCode = exception.getSubStatusCode();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String recordAddressResolutionStart(URI targetEndpoint) {
        String identifier = Utils.randomUUID().toString();
        AddressResolutionStatistics resolutionStatistics = new AddressResolutionStatistics();
        resolutionStatistics.startTime = ZonedDateTime.now(ZoneOffset.UTC);
        resolutionStatistics.endTime = ZonedDateTime.of(LocalDateTime.MAX, ZoneOffset.UTC);
        resolutionStatistics.targetEndpoint = targetEndpoint == null ? "<NULL>" : targetEndpoint.toString();
        ClientSideRequestStatistics clientSideRequestStatistics = this;
        synchronized (clientSideRequestStatistics) {
            this.addressResolutionStatistics.put(identifier, resolutionStatistics);
        }
        return identifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recordAddressResolutionEnd(String identifier) {
        if (StringUtils.isEmpty((CharSequence)identifier)) {
            return;
        }
        ZonedDateTime responseTime = ZonedDateTime.now(ZoneOffset.UTC);
        ClientSideRequestStatistics clientSideRequestStatistics = this;
        synchronized (clientSideRequestStatistics) {
            if (!this.addressResolutionStatistics.containsKey(identifier)) {
                throw new IllegalArgumentException("Identifier " + identifier + " does not exist. Please call start before calling end");
            }
            if (responseTime.isAfter(this.requestEndTime)) {
                this.requestEndTime = responseTime;
            }
            AddressResolutionStatistics resolutionStatistics = this.addressResolutionStatistics.get(identifier);
            resolutionStatistics.endTime = responseTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        ClientSideRequestStatistics clientSideRequestStatistics = this;
        synchronized (clientSideRequestStatistics) {
            stringBuilder.append("RequestStartTime: ").append("\"").append(this.requestStartTime.format(RESPONSE_TIME_FORMATTER)).append("\"").append(", ").append("RequestEndTime: ").append("\"").append(this.requestEndTime.format(RESPONSE_TIME_FORMATTER)).append("\"").append(", ").append("Duration: ").append(Duration.between(this.requestStartTime, this.requestEndTime).toMillis()).append(" ms, ").append("Connection Mode : " + this.connectionMode.toString() + ", ").append("NUMBER of regions attempted: ").append(this.regionsContacted.isEmpty() ? 1 : this.regionsContacted.size()).append(System.lineSeparator());
            for (StoreResponseStatistics storeResponseStatistics : this.responseStatisticsList) {
                stringBuilder.append(storeResponseStatistics.toString()).append(System.lineSeparator());
            }
            for (AddressResolutionStatistics value : this.addressResolutionStatistics.values()) {
                stringBuilder.append(value.toString()).append(System.lineSeparator());
            }
            int supplementalResponseStatisticsListCount = this.supplementalResponseStatisticsList.size();
            int initialIndex = Math.max(supplementalResponseStatisticsListCount - 10, 0);
            if (initialIndex != 0) {
                stringBuilder.append("  -- Displaying only the last ").append(10).append(" head/headfeed requests. Total head/headfeed requests: ").append(supplementalResponseStatisticsListCount);
            }
            for (int i = initialIndex; i < supplementalResponseStatisticsListCount; ++i) {
                stringBuilder.append(this.supplementalResponseStatisticsList.get(i).toString()).append(System.lineSeparator());
            }
            if (this.gatewayStatistic != null) {
                stringBuilder.append(this.gatewayStatistic).append(System.lineSeparator());
            }
            this.printSystemInformation(stringBuilder);
        }
        String requestStatsString = stringBuilder.toString();
        if (!requestStatsString.isEmpty()) {
            return System.lineSeparator() + requestStatsString;
        }
        return "";
    }

    List<URI> getContactedReplicas() {
        return this.contactedReplicas;
    }

    void setContactedReplicas(List<URI> contactedReplicas) {
        this.contactedReplicas = contactedReplicas;
    }

    Set<URI> getFailedReplicas() {
        return this.failedReplicas;
    }

    void setFailedReplicas(Set<URI> failedReplicas) {
        this.failedReplicas = failedReplicas;
    }

    Set<URI> getRegionsContacted() {
        return this.regionsContacted;
    }

    void setRegionsContacted(Set<URI> regionsContacted) {
        this.regionsContacted = regionsContacted;
    }

    private void printSystemInformation(StringBuilder stringBuilder) {
        try {
            long totalMemory = Runtime.getRuntime().totalMemory() / 1024L;
            long freeMemory = Runtime.getRuntime().freeMemory() / 1024L;
            long maxMemory = Runtime.getRuntime().maxMemory() / 1024L;
            String usedMemory = totalMemory - freeMemory + " KB";
            String availableMemory = maxMemory - (totalMemory - freeMemory) + " KB";
            String processCpuLoad = Double.toString(mbean.getProcessCpuLoad());
            String systemCpuLoad = Double.toString(mbean.getSystemCpuLoad());
            stringBuilder.append("System State Information -------").append(System.lineSeparator());
            stringBuilder.append("Used Memory : " + usedMemory).append(System.lineSeparator());
            stringBuilder.append("Available Memory : " + availableMemory).append(System.lineSeparator());
            stringBuilder.append("CPU Process Load : " + processCpuLoad).append(System.lineSeparator());
            stringBuilder.append("CPU System Load : " + systemCpuLoad).append(System.lineSeparator());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String formatDateTime(ZonedDateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return dateTime.format(RESPONSE_TIME_FORMATTER);
    }

    private class GatewayStatistic {
        private OperationType operationType;
        private int statusCode;
        private int subStatusCode;
        private String sessionToken;
        private String requestCharge;

        private GatewayStatistic() {
        }

        public String toString() {
            return "Gateway statistics{ Operation Type : " + (Object)((Object)this.operationType) + "Status Code : " + this.statusCode + "Substatus Code : " + this.statusCode + "Session Token : " + this.sessionToken + "Request Charge : " + this.requestCharge + '}';
        }
    }

    private class AddressResolutionStatistics {
        private ZonedDateTime startTime;
        private ZonedDateTime endTime;
        private String targetEndpoint;

        AddressResolutionStatistics() {
        }

        public String toString() {
            return "AddressResolutionStatistics{startTime=\"" + ClientSideRequestStatistics.formatDateTime(this.startTime) + "\", endTime=\"" + ClientSideRequestStatistics.formatDateTime(this.endTime) + "\", targetEndpoint='" + this.targetEndpoint + '\'' + '}';
        }
    }

    private class StoreResponseStatistics {
        private ZonedDateTime requestResponseTime;
        private StoreResult storeResult;
        private ResourceType requestResourceType;
        private OperationType requestOperationType;

        private StoreResponseStatistics() {
        }

        public String toString() {
            return "StoreResponseStatistics{requestResponseTime=\"" + ClientSideRequestStatistics.formatDateTime(this.requestResponseTime) + "\", storeResult=" + this.storeResult + ", requestResourceType=" + (Object)((Object)this.requestResourceType) + ", requestOperationType=" + (Object)((Object)this.requestOperationType) + '}';
        }
    }
}

