/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.ChangeFeedOptions;
import com.azure.cosmos.CosmosAsyncConflict;
import com.azure.cosmos.CosmosAsyncContainerResponse;
import com.azure.cosmos.CosmosAsyncDatabase;
import com.azure.cosmos.CosmosAsyncItemResponse;
import com.azure.cosmos.CosmosAsyncScripts;
import com.azure.cosmos.CosmosConflictProperties;
import com.azure.cosmos.CosmosContainerProperties;
import com.azure.cosmos.CosmosContainerRequestOptions;
import com.azure.cosmos.CosmosItemProperties;
import com.azure.cosmos.CosmosItemRequestOptions;
import com.azure.cosmos.FeedOptions;
import com.azure.cosmos.FeedResponse;
import com.azure.cosmos.PartitionKey;
import com.azure.cosmos.Resource;
import com.azure.cosmos.SqlQuerySpec;
import com.azure.cosmos.implementation.Document;
import com.azure.cosmos.implementation.DocumentCollection;
import com.azure.cosmos.implementation.Offer;
import com.azure.cosmos.implementation.RequestOptions;
import com.azure.cosmos.implementation.ResourceResponse;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CosmosAsyncContainer {
    private final CosmosAsyncDatabase database;
    private final String id;
    private final String link;
    private CosmosAsyncScripts scripts;

    CosmosAsyncContainer(String id, CosmosAsyncDatabase database) {
        this.id = id;
        this.database = database;
        this.link = this.getParentLink() + "/" + this.getURIPathSegment() + "/" + this.getId();
    }

    public String getId() {
        return this.id;
    }

    public Mono<CosmosAsyncContainerResponse> read() {
        return this.read(new CosmosContainerRequestOptions());
    }

    public Mono<CosmosAsyncContainerResponse> read(CosmosContainerRequestOptions options) {
        if (options == null) {
            options = new CosmosContainerRequestOptions();
        }
        return this.database.getDocClientWrapper().readCollection(this.getLink(), options.toRequestOptions()).map(response -> new CosmosAsyncContainerResponse((ResourceResponse<DocumentCollection>)response, this.database)).single();
    }

    public Mono<CosmosAsyncContainerResponse> delete(CosmosContainerRequestOptions options) {
        if (options == null) {
            options = new CosmosContainerRequestOptions();
        }
        return this.database.getDocClientWrapper().deleteCollection(this.getLink(), options.toRequestOptions()).map(response -> new CosmosAsyncContainerResponse((ResourceResponse<DocumentCollection>)response, this.database)).single();
    }

    public Mono<CosmosAsyncContainerResponse> delete() {
        return this.delete(new CosmosContainerRequestOptions());
    }

    public Mono<CosmosAsyncContainerResponse> replace(CosmosContainerProperties containerSettings) {
        return this.replace(containerSettings, null);
    }

    public Mono<CosmosAsyncContainerResponse> replace(CosmosContainerProperties containerSettings, CosmosContainerRequestOptions options) {
        Resource.validateResource(containerSettings);
        if (options == null) {
            options = new CosmosContainerRequestOptions();
        }
        return this.database.getDocClientWrapper().replaceCollection(containerSettings.getV2Collection(), options.toRequestOptions()).map(response -> new CosmosAsyncContainerResponse((ResourceResponse<DocumentCollection>)response, this.database)).single();
    }

    public <T> Mono<CosmosAsyncItemResponse<T>> createItem(T item) {
        return this.createItem(item, new CosmosItemRequestOptions());
    }

    public <T> Mono<CosmosAsyncItemResponse<T>> createItem(T item, PartitionKey partitionKey, CosmosItemRequestOptions options) {
        if (options == null) {
            options = new CosmosItemRequestOptions();
        }
        options.setPartitionKey(partitionKey);
        return this.createItem(item, options);
    }

    public <T> Mono<CosmosAsyncItemResponse<T>> createItem(T item, CosmosItemRequestOptions options) {
        if (options == null) {
            options = new CosmosItemRequestOptions();
        }
        Class<?> itemType = item.getClass();
        RequestOptions requestOptions = options.toRequestOptions();
        return this.database.getDocClientWrapper().createDocument(this.getLink(), item, requestOptions, true).map(response -> new CosmosAsyncItemResponse((ResourceResponse<Document>)response, itemType)).single();
    }

    public <T> Mono<CosmosAsyncItemResponse<T>> upsertItem(T item) {
        return this.upsertItem(item, new CosmosItemRequestOptions());
    }

    public <T> Mono<CosmosAsyncItemResponse<T>> upsertItem(T item, CosmosItemRequestOptions options) {
        if (options == null) {
            options = new CosmosItemRequestOptions();
        }
        Class<?> itemType = item.getClass();
        return this.getDatabase().getDocClientWrapper().upsertDocument(this.getLink(), CosmosItemProperties.fromObject(item), options.toRequestOptions(), true).map(response -> new CosmosAsyncItemResponse((ResourceResponse<Document>)response, itemType)).single();
    }

    public <T> Flux<FeedResponse<T>> readAllItems(Class<T> klass) {
        return this.readAllItems(new FeedOptions(), klass);
    }

    public <T> Flux<FeedResponse<T>> readAllItems(FeedOptions options, Class<T> klass) {
        return this.getDatabase().getDocClientWrapper().readDocuments(this.getLink(), options).map(response -> BridgeInternal.createFeedResponse(CosmosItemProperties.getTypedResultsFromV2Results(response.getResults(), klass), response.getResponseHeaders()));
    }

    public <T> Flux<FeedResponse<T>> queryItems(String query, Class<T> klass) {
        return this.queryItems(new SqlQuerySpec(query), klass);
    }

    public <T> Flux<FeedResponse<T>> queryItems(String query, FeedOptions options, Class<T> klass) {
        return this.queryItems(new SqlQuerySpec(query), options, klass);
    }

    public <T> Flux<FeedResponse<T>> queryItems(SqlQuerySpec querySpec, Class<T> klass) {
        return this.queryItems(querySpec, new FeedOptions(), klass);
    }

    public <T> Flux<FeedResponse<T>> queryItems(SqlQuerySpec querySpec, FeedOptions options, Class<T> klass) {
        return this.getDatabase().getDocClientWrapper().queryDocuments(this.getLink(), querySpec, options).map(response -> BridgeInternal.createFeedResponseWithQueryMetrics(CosmosItemProperties.getTypedResultsFromV2Results(response.getResults(), klass), response.getResponseHeaders(), response.queryMetrics()));
    }

    public Flux<FeedResponse<CosmosItemProperties>> queryChangeFeedItems(ChangeFeedOptions changeFeedOptions) {
        return this.getDatabase().getDocClientWrapper().queryDocumentChangeFeed(this.getLink(), changeFeedOptions).map(response -> new FeedResponse<CosmosItemProperties>(CosmosItemProperties.getFromV2Results(response.getResults()), response.getResponseHeaders(), false));
    }

    public <T> Mono<CosmosAsyncItemResponse<T>> readItem(String itemId, PartitionKey partitionKey, Class<T> itemType) {
        return this.readItem(itemId, partitionKey, new CosmosItemRequestOptions(partitionKey), itemType);
    }

    public <T> Mono<CosmosAsyncItemResponse<T>> readItem(String itemId, PartitionKey partitionKey, CosmosItemRequestOptions options, Class<T> itemType) {
        if (options == null) {
            options = new CosmosItemRequestOptions();
        }
        options.setPartitionKey(partitionKey);
        RequestOptions requestOptions = options.toRequestOptions();
        return this.getDatabase().getDocClientWrapper().readDocument(this.getItemLink(itemId), requestOptions).map(response -> new CosmosAsyncItemResponse((ResourceResponse<Document>)response, itemType)).single();
    }

    public <T> Mono<CosmosAsyncItemResponse<T>> replaceItem(T item, String itemId, PartitionKey partitionKey) {
        return this.replaceItem(item, itemId, partitionKey, new CosmosItemRequestOptions());
    }

    public <T> Mono<CosmosAsyncItemResponse<T>> replaceItem(T item, String itemId, PartitionKey partitionKey, CosmosItemRequestOptions options) {
        Document doc = CosmosItemProperties.fromObject(item);
        if (options == null) {
            options = new CosmosItemRequestOptions();
        }
        options.setPartitionKey(partitionKey);
        Class<?> itemType = item.getClass();
        return this.getDatabase().getDocClientWrapper().replaceDocument(this.getItemLink(itemId), doc, options.toRequestOptions()).map(response -> new CosmosAsyncItemResponse((ResourceResponse<Document>)response, itemType)).single();
    }

    public Mono<CosmosAsyncItemResponse> deleteItem(String itemId, PartitionKey partitionKey) {
        return this.deleteItem(itemId, partitionKey, new CosmosItemRequestOptions());
    }

    public Mono<CosmosAsyncItemResponse> deleteItem(String itemId, PartitionKey partitionKey, CosmosItemRequestOptions options) {
        if (options == null) {
            options = new CosmosItemRequestOptions();
        }
        options.setPartitionKey(partitionKey);
        RequestOptions requestOptions = options.toRequestOptions();
        return this.getDatabase().getDocClientWrapper().deleteDocument(this.getItemLink(itemId), requestOptions).map(response -> new CosmosAsyncItemResponse<Object>((ResourceResponse<Document>)response, Object.class)).single();
    }

    private String getItemLink(String itemId) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getLink());
        builder.append("/");
        builder.append("docs");
        builder.append("/");
        builder.append(itemId);
        return builder.toString();
    }

    public CosmosAsyncScripts getScripts() {
        if (this.scripts == null) {
            this.scripts = new CosmosAsyncScripts(this);
        }
        return this.scripts;
    }

    public Flux<FeedResponse<CosmosConflictProperties>> readAllConflicts(FeedOptions options) {
        return this.database.getDocClientWrapper().readConflicts(this.getLink(), options).map(response -> BridgeInternal.createFeedResponse(CosmosConflictProperties.getFromV2Results(response.getResults()), response.getResponseHeaders()));
    }

    public Flux<FeedResponse<CosmosConflictProperties>> queryConflicts(String query) {
        return this.queryConflicts(query, null);
    }

    public Flux<FeedResponse<CosmosConflictProperties>> queryConflicts(String query, FeedOptions options) {
        return this.database.getDocClientWrapper().queryConflicts(this.getLink(), query, options).map(response -> BridgeInternal.createFeedResponse(CosmosConflictProperties.getFromV2Results(response.getResults()), response.getResponseHeaders()));
    }

    public CosmosAsyncConflict getConflict(String id) {
        return new CosmosAsyncConflict(id, this);
    }

    public Mono<Integer> readProvisionedThroughput() {
        return this.read().flatMap(cosmosContainerResponse -> this.database.getDocClientWrapper().queryOffers("select * from c where c.offerResourceId = '" + cosmosContainerResponse.getProperties().getResourceId() + "'", new FeedOptions()).single()).flatMap(offerFeedResponse -> {
            if (offerFeedResponse.getResults().isEmpty()) {
                return Mono.error((Throwable)BridgeInternal.createCosmosClientException(400, "No offers found for the resource"));
            }
            return this.database.getDocClientWrapper().readOffer(((Offer)offerFeedResponse.getResults().get(0)).getSelfLink()).single();
        }).map(cosmosOfferResponse -> ((Offer)cosmosOfferResponse.getResource()).getThroughput());
    }

    public Mono<Integer> replaceProvisionedThroughput(int requestUnitsPerSecond) {
        return this.read().flatMap(cosmosContainerResponse -> this.database.getDocClientWrapper().queryOffers("select * from c where c.offerResourceId = '" + cosmosContainerResponse.getProperties().getResourceId() + "'", new FeedOptions()).single()).flatMap(offerFeedResponse -> {
            if (offerFeedResponse.getResults().isEmpty()) {
                return Mono.error((Throwable)BridgeInternal.createCosmosClientException(400, "No offers found for the resource"));
            }
            Offer offer = (Offer)offerFeedResponse.getResults().get(0);
            offer.setThroughput(requestUnitsPerSecond);
            return this.database.getDocClientWrapper().replaceOffer(offer).single();
        }).map(offerResourceResponse -> ((Offer)offerResourceResponse.getResource()).getThroughput());
    }

    public CosmosAsyncDatabase getDatabase() {
        return this.database;
    }

    String getURIPathSegment() {
        return "colls";
    }

    String getParentLink() {
        return this.database.getLink();
    }

    String getLink() {
        return this.link;
    }
}

