/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.CosmosItemProperties;
import com.azure.cosmos.CosmosResponse;
import com.azure.cosmos.implementation.Document;
import com.azure.cosmos.implementation.ResourceResponse;
import com.azure.cosmos.implementation.Utils;
import org.apache.commons.lang3.StringUtils;

public class CosmosAsyncItemResponse<T>
extends CosmosResponse<CosmosItemProperties> {
    private final Class<T> itemClassType;
    private final String responseBodyString;
    private T item;

    CosmosAsyncItemResponse(ResourceResponse<Document> response, Class<T> klass) {
        super(response);
        this.itemClassType = klass;
        this.responseBodyString = response.getBodyAsString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getResource() {
        if (this.item != null) {
            return this.item;
        }
        if (this.itemClassType == CosmosItemProperties.class) {
            this.item = this.getProperties();
            return this.item;
        }
        if (this.item == null) {
            CosmosAsyncItemResponse cosmosAsyncItemResponse = this;
            synchronized (cosmosAsyncItemResponse) {
                if (this.item == null && !StringUtils.isEmpty((CharSequence)this.responseBodyString)) {
                    this.item = Utils.parse(this.responseBodyString, this.itemClassType);
                }
            }
        }
        return this.item;
    }

    @Override
    public CosmosItemProperties getProperties() {
        this.ensureCosmosItemPropertiesInitialized();
        return (CosmosItemProperties)super.getProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureCosmosItemPropertiesInitialized() {
        if (super.getProperties() == null) {
            CosmosAsyncItemResponse cosmosAsyncItemResponse = this;
            synchronized (cosmosAsyncItemResponse) {
                if (super.getProperties() == null) {
                    if (StringUtils.isEmpty((CharSequence)this.responseBodyString)) {
                        super.setProperties(null);
                    } else {
                        CosmosItemProperties props = new CosmosItemProperties(this.responseBodyString);
                        super.setProperties(props);
                    }
                }
            }
        }
    }
}

