/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.CosmosAsyncPermission;
import com.azure.cosmos.CosmosAsyncUser;
import com.azure.cosmos.CosmosPermissionProperties;
import com.azure.cosmos.CosmosResponse;
import com.azure.cosmos.implementation.Permission;
import com.azure.cosmos.implementation.ResourceResponse;
import org.apache.commons.lang3.StringUtils;

public class CosmosAsyncPermissionResponse
extends CosmosResponse<CosmosPermissionProperties> {
    private final CosmosAsyncPermission permissionClient;

    CosmosAsyncPermissionResponse(ResourceResponse<Permission> response, CosmosAsyncUser cosmosUser) {
        super(response);
        String bodyAsString = response.getBodyAsString();
        if (StringUtils.isEmpty((CharSequence)bodyAsString)) {
            super.setProperties(null);
            this.permissionClient = null;
        } else {
            CosmosPermissionProperties props = new CosmosPermissionProperties(bodyAsString);
            super.setProperties(props);
            this.permissionClient = new CosmosAsyncPermission(props.getId(), cosmosUser);
        }
    }

    @Override
    public CosmosPermissionProperties getProperties() {
        return (CosmosPermissionProperties)super.getProperties();
    }

    public CosmosAsyncPermission getPermission() {
        return this.permissionClient;
    }
}

