/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.CosmosAsyncDatabase;
import com.azure.cosmos.CosmosAsyncStoredProcedure;
import com.azure.cosmos.CosmosAsyncStoredProcedureResponse;
import com.azure.cosmos.CosmosAsyncTrigger;
import com.azure.cosmos.CosmosAsyncTriggerResponse;
import com.azure.cosmos.CosmosAsyncUserDefinedFunction;
import com.azure.cosmos.CosmosAsyncUserDefinedFunctionResponse;
import com.azure.cosmos.CosmosStoredProcedureProperties;
import com.azure.cosmos.CosmosStoredProcedureRequestOptions;
import com.azure.cosmos.CosmosTriggerProperties;
import com.azure.cosmos.CosmosUserDefinedFunctionProperties;
import com.azure.cosmos.FeedOptions;
import com.azure.cosmos.FeedResponse;
import com.azure.cosmos.SqlQuerySpec;
import com.azure.cosmos.implementation.ResourceResponse;
import com.azure.cosmos.implementation.StoredProcedure;
import com.azure.cosmos.implementation.Trigger;
import com.azure.cosmos.implementation.UserDefinedFunction;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CosmosAsyncScripts {
    private final CosmosAsyncContainer container;
    private final CosmosAsyncDatabase database;

    CosmosAsyncScripts(CosmosAsyncContainer container) {
        this.container = container;
        this.database = container.getDatabase();
    }

    public Mono<CosmosAsyncStoredProcedureResponse> createStoredProcedure(CosmosStoredProcedureProperties properties) {
        return this.createStoredProcedure(properties, new CosmosStoredProcedureRequestOptions());
    }

    public Mono<CosmosAsyncStoredProcedureResponse> createStoredProcedure(CosmosStoredProcedureProperties properties, CosmosStoredProcedureRequestOptions options) {
        if (options == null) {
            options = new CosmosStoredProcedureRequestOptions();
        }
        StoredProcedure sProc = new StoredProcedure();
        sProc.setId(properties.getId());
        sProc.setBody(properties.getBody());
        return this.database.getDocClientWrapper().createStoredProcedure(this.container.getLink(), sProc, options.toRequestOptions()).map(response -> new CosmosAsyncStoredProcedureResponse((ResourceResponse<StoredProcedure>)response, this.container)).single();
    }

    public Flux<FeedResponse<CosmosStoredProcedureProperties>> readAllStoredProcedures(FeedOptions options) {
        return this.database.getDocClientWrapper().readStoredProcedures(this.container.getLink(), options).map(response -> BridgeInternal.createFeedResponse(CosmosStoredProcedureProperties.getFromV2Results(response.getResults()), response.getResponseHeaders()));
    }

    public Flux<FeedResponse<CosmosStoredProcedureProperties>> queryStoredProcedures(String query, FeedOptions options) {
        return this.queryStoredProcedures(new SqlQuerySpec(query), options);
    }

    public Flux<FeedResponse<CosmosStoredProcedureProperties>> queryStoredProcedures(SqlQuerySpec querySpec, FeedOptions options) {
        return this.database.getDocClientWrapper().queryStoredProcedures(this.container.getLink(), querySpec, options).map(response -> BridgeInternal.createFeedResponse(CosmosStoredProcedureProperties.getFromV2Results(response.getResults()), response.getResponseHeaders()));
    }

    public CosmosAsyncStoredProcedure getStoredProcedure(String id) {
        return new CosmosAsyncStoredProcedure(id, this.container);
    }

    public Mono<CosmosAsyncUserDefinedFunctionResponse> createUserDefinedFunction(CosmosUserDefinedFunctionProperties properties) {
        UserDefinedFunction udf = new UserDefinedFunction();
        udf.setId(properties.getId());
        udf.setBody(properties.getBody());
        return this.database.getDocClientWrapper().createUserDefinedFunction(this.container.getLink(), udf, null).map(response -> new CosmosAsyncUserDefinedFunctionResponse((ResourceResponse<UserDefinedFunction>)response, this.container)).single();
    }

    public Flux<FeedResponse<CosmosUserDefinedFunctionProperties>> readAllUserDefinedFunctions(FeedOptions options) {
        return this.database.getDocClientWrapper().readUserDefinedFunctions(this.container.getLink(), options).map(response -> BridgeInternal.createFeedResponse(CosmosUserDefinedFunctionProperties.getFromV2Results(response.getResults()), response.getResponseHeaders()));
    }

    public Flux<FeedResponse<CosmosUserDefinedFunctionProperties>> queryUserDefinedFunctions(String query, FeedOptions options) {
        return this.queryUserDefinedFunctions(new SqlQuerySpec(query), options);
    }

    public Flux<FeedResponse<CosmosUserDefinedFunctionProperties>> queryUserDefinedFunctions(SqlQuerySpec querySpec, FeedOptions options) {
        return this.database.getDocClientWrapper().queryUserDefinedFunctions(this.container.getLink(), querySpec, options).map(response -> BridgeInternal.createFeedResponse(CosmosUserDefinedFunctionProperties.getFromV2Results(response.getResults()), response.getResponseHeaders()));
    }

    public CosmosAsyncUserDefinedFunction getUserDefinedFunction(String id) {
        return new CosmosAsyncUserDefinedFunction(id, this.container);
    }

    public Mono<CosmosAsyncTriggerResponse> createTrigger(CosmosTriggerProperties properties) {
        Trigger trigger = new Trigger(properties.toJson());
        return this.database.getDocClientWrapper().createTrigger(this.container.getLink(), trigger, null).map(response -> new CosmosAsyncTriggerResponse((ResourceResponse<Trigger>)response, this.container)).single();
    }

    public Flux<FeedResponse<CosmosTriggerProperties>> readAllTriggers(FeedOptions options) {
        return this.database.getDocClientWrapper().readTriggers(this.container.getLink(), options).map(response -> BridgeInternal.createFeedResponse(CosmosTriggerProperties.getFromV2Results(response.getResults()), response.getResponseHeaders()));
    }

    public Flux<FeedResponse<CosmosTriggerProperties>> queryTriggers(String query, FeedOptions options) {
        return this.queryTriggers(new SqlQuerySpec(query), options);
    }

    public Flux<FeedResponse<CosmosTriggerProperties>> queryTriggers(SqlQuerySpec querySpec, FeedOptions options) {
        return this.database.getDocClientWrapper().queryTriggers(this.container.getLink(), querySpec, options).map(response -> BridgeInternal.createFeedResponse(CosmosTriggerProperties.getFromV2Results(response.getResults()), response.getResponseHeaders()));
    }

    public CosmosAsyncTrigger getTrigger(String id) {
        return new CosmosAsyncTrigger(id, this.container);
    }
}

