/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.CosmosAsyncDatabase;
import com.azure.cosmos.CosmosAsyncUser;
import com.azure.cosmos.CosmosResponse;
import com.azure.cosmos.CosmosUserProperties;
import com.azure.cosmos.implementation.ResourceResponse;
import com.azure.cosmos.implementation.User;
import org.apache.commons.lang3.StringUtils;

public class CosmosAsyncUserResponse
extends CosmosResponse<CosmosUserProperties> {
    private final CosmosAsyncUser user;

    CosmosAsyncUserResponse(ResourceResponse<User> response, CosmosAsyncDatabase database) {
        super(response);
        String bodyAsString = response.getBodyAsString();
        if (StringUtils.isEmpty((CharSequence)bodyAsString)) {
            super.setProperties(null);
            this.user = null;
        } else {
            CosmosUserProperties props = new CosmosUserProperties(bodyAsString);
            super.setProperties(props);
            this.user = new CosmosAsyncUser(props.getId(), database);
        }
    }

    public CosmosAsyncUser getUser() {
        return this.user;
    }

    @Override
    public CosmosUserProperties getProperties() {
        return (CosmosUserProperties)super.getProperties();
    }
}

