/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.CosmosAsyncScripts;
import com.azure.cosmos.CosmosAsyncStoredProcedureResponse;
import com.azure.cosmos.CosmosAsyncTriggerResponse;
import com.azure.cosmos.CosmosAsyncUserDefinedFunctionResponse;
import com.azure.cosmos.CosmosClientException;
import com.azure.cosmos.CosmosContainer;
import com.azure.cosmos.CosmosStoredProcedure;
import com.azure.cosmos.CosmosStoredProcedureProperties;
import com.azure.cosmos.CosmosStoredProcedureRequestOptions;
import com.azure.cosmos.CosmosStoredProcedureResponse;
import com.azure.cosmos.CosmosTrigger;
import com.azure.cosmos.CosmosTriggerProperties;
import com.azure.cosmos.CosmosTriggerResponse;
import com.azure.cosmos.CosmosUserDefinedFunction;
import com.azure.cosmos.CosmosUserDefinedFunctionProperties;
import com.azure.cosmos.CosmosUserDefinedFunctionResponse;
import com.azure.cosmos.FeedOptions;
import com.azure.cosmos.FeedResponse;
import com.azure.cosmos.SqlQuerySpec;
import java.util.Iterator;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CosmosScripts {
    private final CosmosContainer container;
    private final CosmosAsyncScripts asyncScripts;

    CosmosScripts(CosmosContainer container, CosmosAsyncScripts asyncScripts) {
        this.container = container;
        this.asyncScripts = asyncScripts;
    }

    public CosmosStoredProcedureResponse createStoredProcedure(CosmosStoredProcedureProperties properties) throws CosmosClientException {
        return this.mapStoredProcedureResponseAndBlock(this.asyncScripts.createStoredProcedure(properties, new CosmosStoredProcedureRequestOptions()));
    }

    public CosmosStoredProcedureResponse createStoredProcedure(CosmosStoredProcedureProperties properties, CosmosStoredProcedureRequestOptions options) throws CosmosClientException {
        return this.mapStoredProcedureResponseAndBlock(this.asyncScripts.createStoredProcedure(properties, options));
    }

    public Iterator<FeedResponse<CosmosStoredProcedureProperties>> readAllStoredProcedures(FeedOptions options) {
        return this.getFeedIterator(this.asyncScripts.readAllStoredProcedures(options));
    }

    public Iterator<FeedResponse<CosmosStoredProcedureProperties>> queryStoredProcedures(String query, FeedOptions options) {
        return this.getFeedIterator(this.asyncScripts.queryStoredProcedures(query, options));
    }

    public Iterator<FeedResponse<CosmosStoredProcedureProperties>> queryStoredProcedures(SqlQuerySpec querySpec, FeedOptions options) {
        return this.getFeedIterator(this.asyncScripts.queryStoredProcedures(querySpec, options));
    }

    public CosmosStoredProcedure getStoredProcedure(String id) {
        return new CosmosStoredProcedure(id, this.container, this.asyncScripts.getStoredProcedure(id));
    }

    public CosmosUserDefinedFunctionResponse createUserDefinedFunction(CosmosUserDefinedFunctionProperties properties) throws CosmosClientException {
        return this.mapUDFResponseAndBlock(this.asyncScripts.createUserDefinedFunction(properties));
    }

    public Iterator<FeedResponse<CosmosUserDefinedFunctionProperties>> readAllUserDefinedFunctions(FeedOptions options) {
        return this.getFeedIterator(this.asyncScripts.readAllUserDefinedFunctions(options));
    }

    public Iterator<FeedResponse<CosmosUserDefinedFunctionProperties>> queryUserDefinedFunctions(String query, FeedOptions options) {
        return this.getFeedIterator(this.asyncScripts.queryUserDefinedFunctions(new SqlQuerySpec(query), options));
    }

    public Iterator<FeedResponse<CosmosUserDefinedFunctionProperties>> queryUserDefinedFunctions(SqlQuerySpec querySpec, FeedOptions options) {
        return this.getFeedIterator(this.asyncScripts.queryUserDefinedFunctions(querySpec, options));
    }

    public CosmosUserDefinedFunction getUserDefinedFunction(String id) {
        return new CosmosUserDefinedFunction(id, this.container, this.asyncScripts.getUserDefinedFunction(id));
    }

    public CosmosTriggerResponse createTrigger(CosmosTriggerProperties properties) throws CosmosClientException {
        return this.mapTriggerResponseAndBlock(this.asyncScripts.createTrigger(properties));
    }

    public Iterator<FeedResponse<CosmosTriggerProperties>> readAllTriggers(FeedOptions options) {
        return this.getFeedIterator(this.asyncScripts.readAllTriggers(options));
    }

    public Iterator<FeedResponse<CosmosTriggerProperties>> queryTriggers(String query, FeedOptions options) {
        return this.getFeedIterator(this.asyncScripts.queryTriggers(query, options));
    }

    public Iterator<FeedResponse<CosmosTriggerProperties>> queryTriggers(SqlQuerySpec querySpec, FeedOptions options) {
        return this.getFeedIterator(this.asyncScripts.queryTriggers(querySpec, options));
    }

    public CosmosTrigger getTrigger(String id) {
        return new CosmosTrigger(id, this.container, this.asyncScripts.getTrigger(id));
    }

    CosmosStoredProcedureResponse mapStoredProcedureResponseAndBlock(Mono<CosmosAsyncStoredProcedureResponse> storedProcedureResponseMono) throws CosmosClientException {
        try {
            return (CosmosStoredProcedureResponse)storedProcedureResponseMono.map(this::convertResponse).block();
        }
        catch (Exception ex) {
            Throwable throwable = Exceptions.unwrap((Throwable)ex);
            if (throwable instanceof CosmosClientException) {
                throw (CosmosClientException)throwable;
            }
            throw ex;
        }
    }

    CosmosStoredProcedureResponse convertResponse(CosmosAsyncStoredProcedureResponse response) {
        if (response.getStoredProcedure() != null) {
            return new CosmosStoredProcedureResponse(response, this.getStoredProcedure(response.getStoredProcedure().id()));
        }
        return new CosmosStoredProcedureResponse(response, null);
    }

    CosmosUserDefinedFunctionResponse mapUDFResponseAndBlock(Mono<CosmosAsyncUserDefinedFunctionResponse> responseMono) throws CosmosClientException {
        try {
            return (CosmosUserDefinedFunctionResponse)responseMono.map(this::convertResponse).block();
        }
        catch (Exception ex) {
            Throwable throwable = Exceptions.unwrap((Throwable)ex);
            if (throwable instanceof CosmosClientException) {
                throw (CosmosClientException)throwable;
            }
            throw Exceptions.propagate((Throwable)ex);
        }
    }

    CosmosUserDefinedFunctionResponse convertResponse(CosmosAsyncUserDefinedFunctionResponse response) {
        if (response.getUserDefinedFunction() != null) {
            return new CosmosUserDefinedFunctionResponse(response, this.getUserDefinedFunction(response.getUserDefinedFunction().getId()));
        }
        return new CosmosUserDefinedFunctionResponse(response, null);
    }

    CosmosTriggerResponse mapTriggerResponseAndBlock(Mono<CosmosAsyncTriggerResponse> responseMono) throws CosmosClientException {
        try {
            return (CosmosTriggerResponse)responseMono.map(this::convertResponse).block();
        }
        catch (Exception ex) {
            Throwable throwable = Exceptions.unwrap((Throwable)ex);
            if (throwable instanceof CosmosClientException) {
                throw (CosmosClientException)throwable;
            }
            throw Exceptions.propagate((Throwable)ex);
        }
    }

    CosmosTriggerResponse convertResponse(CosmosAsyncTriggerResponse response) {
        if (response.getTrigger() != null) {
            return new CosmosTriggerResponse(response, this.getTrigger(response.getTrigger().getId()));
        }
        return new CosmosTriggerResponse(response, null);
    }

    private <T> Iterator<FeedResponse<T>> getFeedIterator(Flux<FeedResponse<T>> itemFlux) {
        return itemFlux.toIterable(1).iterator();
    }
}

