/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.FeedResponseDiagnostics;
import com.azure.cosmos.implementation.QueryMetrics;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;

public class FeedResponse<T> {
    private final List<T> results;
    private final Map<String, String> header;
    private final HashMap<String, Long> usageHeaders;
    private final HashMap<String, Long> quotaHeaders;
    private final boolean useEtagAsContinuation;
    final boolean nochanges;
    private final ConcurrentMap<String, QueryMetrics> queryMetricsMap;
    private final String defaultPartition = "0";
    private final FeedResponseDiagnostics feedResponseDiagnostics;

    FeedResponse(List<T> results, Map<String, String> headers) {
        this(results, headers, false, false, new ConcurrentHashMap<String, QueryMetrics>());
    }

    FeedResponse(List<T> results, Map<String, String> headers, ConcurrentMap<String, QueryMetrics> queryMetricsMap) {
        this(results, headers, false, false, queryMetricsMap);
    }

    FeedResponse(List<T> results, Map<String, String> header, boolean nochanges) {
        this(results, header, true, nochanges, new ConcurrentHashMap<String, QueryMetrics>());
    }

    private FeedResponse(List<T> results, Map<String, String> header, boolean useEtagAsContinuation, boolean nochanges, ConcurrentMap<String, QueryMetrics> queryMetricsMap) {
        this.results = results;
        this.header = header;
        this.usageHeaders = new HashMap();
        this.quotaHeaders = new HashMap();
        this.useEtagAsContinuation = useEtagAsContinuation;
        this.nochanges = nochanges;
        this.queryMetricsMap = new ConcurrentHashMap<String, QueryMetrics>(queryMetricsMap);
        this.feedResponseDiagnostics = new FeedResponseDiagnostics(queryMetricsMap);
    }

    public List<T> getResults() {
        return this.results;
    }

    public long getDatabaseQuota() {
        return this.maxQuotaHeader("databases");
    }

    public long getDatabaseUsage() {
        return this.currentQuotaHeader("databases");
    }

    public long getCollectionQuota() {
        return this.maxQuotaHeader("collections");
    }

    public long getCollectionUsage() {
        return this.currentQuotaHeader("collections");
    }

    public long getUserQuota() {
        return this.maxQuotaHeader("users");
    }

    public long getUserUsage() {
        return this.currentQuotaHeader("users");
    }

    public long getPermissionQuota() {
        return this.maxQuotaHeader("permissions");
    }

    public long getPermissionUsage() {
        return this.currentQuotaHeader("permissions");
    }

    public long getCollectionSizeQuota() {
        return this.maxQuotaHeader("collectionSize");
    }

    public long getCollectionSizeUsage() {
        return this.currentQuotaHeader("collectionSize");
    }

    public long getStoredProceduresQuota() {
        return this.maxQuotaHeader("storedProcedures");
    }

    public long getStoredProceduresUsage() {
        return this.currentQuotaHeader("storedProcedures");
    }

    public long getTriggersQuota() {
        return this.maxQuotaHeader("triggers");
    }

    public long getTriggersUsage() {
        return this.currentQuotaHeader("triggers");
    }

    public long getUserDefinedFunctionsQuota() {
        return this.maxQuotaHeader("functions");
    }

    public long getUserDefinedFunctionsUsage() {
        return this.currentQuotaHeader("functions");
    }

    public String getMaxResourceQuota() {
        return FeedResponse.getValueOrNull(this.header, "x-ms-resource-quota");
    }

    public String getCurrentResourceQuotaUsage() {
        return FeedResponse.getValueOrNull(this.header, "x-ms-resource-usage");
    }

    public double getRequestCharge() {
        String value = FeedResponse.getValueOrNull(this.header, "x-ms-request-charge");
        if (StringUtils.isEmpty((CharSequence)value)) {
            return 0.0;
        }
        return Double.valueOf(value);
    }

    public String getActivityId() {
        return FeedResponse.getValueOrNull(this.header, "x-ms-activity-id");
    }

    public String getContinuationToken() {
        String headerName = this.useEtagAsContinuation ? "etag" : "x-ms-continuation";
        return FeedResponse.getValueOrNull(this.header, headerName);
    }

    public String getSessionToken() {
        return FeedResponse.getValueOrNull(this.header, "x-ms-session-token");
    }

    public Map<String, String> getResponseHeaders() {
        return this.header;
    }

    private String getQueryMetricsString() {
        return FeedResponse.getValueOrNull(this.getResponseHeaders(), "x-ms-documentdb-query-metrics");
    }

    public FeedResponseDiagnostics getFeedResponseDiagnostics() {
        return this.feedResponseDiagnostics;
    }

    ConcurrentMap<String, QueryMetrics> queryMetrics() {
        if (this.queryMetricsMap != null && !this.queryMetricsMap.isEmpty()) {
            return this.queryMetricsMap;
        }
        if (!StringUtils.isEmpty((CharSequence)this.getQueryMetricsString())) {
            String qm = this.getQueryMetricsString();
            qm = qm + String.format(";%s=%.2f", "requestCharge", this.getRequestCharge());
            this.queryMetricsMap.put("0", QueryMetrics.createFromDelimitedString(qm));
        }
        return this.queryMetricsMap;
    }

    ConcurrentMap<String, QueryMetrics> queryMetricsMap() {
        return this.queryMetricsMap;
    }

    private long currentQuotaHeader(String headerName) {
        if (this.usageHeaders.size() == 0 && !StringUtils.isEmpty((CharSequence)this.getMaxResourceQuota()) && !StringUtils.isEmpty((CharSequence)this.getCurrentResourceQuotaUsage())) {
            this.populateQuotaHeader(this.getMaxResourceQuota(), this.getCurrentResourceQuotaUsage());
        }
        if (this.usageHeaders.containsKey(headerName)) {
            return this.usageHeaders.get(headerName);
        }
        return 0L;
    }

    private long maxQuotaHeader(String headerName) {
        if (this.quotaHeaders.size() == 0 && !StringUtils.isEmpty((CharSequence)this.getMaxResourceQuota()) && !StringUtils.isEmpty((CharSequence)this.getCurrentResourceQuotaUsage())) {
            this.populateQuotaHeader(this.getMaxResourceQuota(), this.getCurrentResourceQuotaUsage());
        }
        if (this.quotaHeaders.containsKey(headerName)) {
            return this.quotaHeaders.get(headerName);
        }
        return 0L;
    }

    private void populateQuotaHeader(String headerMaxQuota, String headerCurrentUsage) {
        String[] headerMaxQuotaWords = headerMaxQuota.split("=|;", -1);
        String[] headerCurrentUsageWords = headerCurrentUsage.split("=|;", -1);
        for (int i = 0; i < headerMaxQuotaWords.length; ++i) {
            if (headerMaxQuotaWords[i].equalsIgnoreCase("databases")) {
                this.quotaHeaders.put("databases", Long.valueOf(headerMaxQuotaWords[i + 1]));
                this.usageHeaders.put("databases", Long.valueOf(headerCurrentUsageWords[i + 1]));
                continue;
            }
            if (headerMaxQuotaWords[i].equalsIgnoreCase("collections")) {
                this.quotaHeaders.put("collections", Long.valueOf(headerMaxQuotaWords[i + 1]));
                this.usageHeaders.put("collections", Long.valueOf(headerCurrentUsageWords[i + 1]));
                continue;
            }
            if (headerMaxQuotaWords[i].equalsIgnoreCase("users")) {
                this.quotaHeaders.put("users", Long.valueOf(headerMaxQuotaWords[i + 1]));
                this.usageHeaders.put("users", Long.valueOf(headerCurrentUsageWords[i + 1]));
                continue;
            }
            if (headerMaxQuotaWords[i].equalsIgnoreCase("permissions")) {
                this.quotaHeaders.put("permissions", Long.valueOf(headerMaxQuotaWords[i + 1]));
                this.usageHeaders.put("permissions", Long.valueOf(headerCurrentUsageWords[i + 1]));
                continue;
            }
            if (headerMaxQuotaWords[i].equalsIgnoreCase("collectionSize")) {
                this.quotaHeaders.put("collectionSize", Long.valueOf(headerMaxQuotaWords[i + 1]));
                this.usageHeaders.put("collectionSize", Long.valueOf(headerCurrentUsageWords[i + 1]));
                continue;
            }
            if (headerMaxQuotaWords[i].equalsIgnoreCase("storedProcedures")) {
                this.quotaHeaders.put("storedProcedures", Long.valueOf(headerMaxQuotaWords[i + 1]));
                this.usageHeaders.put("storedProcedures", Long.valueOf(headerCurrentUsageWords[i + 1]));
                continue;
            }
            if (headerMaxQuotaWords[i].equalsIgnoreCase("triggers")) {
                this.quotaHeaders.put("triggers", Long.valueOf(headerMaxQuotaWords[i + 1]));
                this.usageHeaders.put("triggers", Long.valueOf(headerCurrentUsageWords[i + 1]));
                continue;
            }
            if (!headerMaxQuotaWords[i].equalsIgnoreCase("functions")) continue;
            this.quotaHeaders.put("functions", Long.valueOf(headerMaxQuotaWords[i + 1]));
            this.usageHeaders.put("functions", Long.valueOf(headerCurrentUsageWords[i + 1]));
        }
    }

    private static String getValueOrNull(Map<String, String> map, String key) {
        if (map != null) {
            return map.get(key);
        }
        return null;
    }
}

