/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.DataType;
import com.azure.cosmos.Index;
import com.azure.cosmos.IndexKind;
import org.apache.commons.lang3.StringUtils;

public final class HashIndex
extends Index {
    public HashIndex(DataType dataType) {
        super(IndexKind.HASH);
        this.setDataType(dataType);
    }

    public HashIndex(DataType dataType, int precision) {
        super(IndexKind.HASH);
        this.setDataType(dataType);
        this.setPrecision(precision);
    }

    HashIndex(String jsonString) {
        super(jsonString, IndexKind.HASH);
        if (this.getDataType() == null) {
            throw new IllegalArgumentException("The jsonString doesn't contain a valid 'dataType'.");
        }
    }

    public DataType getDataType() {
        DataType result = null;
        try {
            result = DataType.valueOf(StringUtils.upperCase((String)super.getString("dataType")));
        }
        catch (IllegalArgumentException e) {
            this.getLogger().warn("INVALID index dataType value {}.", (Object)super.getString("dataType"));
        }
        return result;
    }

    public HashIndex setDataType(DataType dataType) {
        super.set("dataType", dataType.toString());
        return this;
    }

    public int getPrecision() {
        return super.getInt("precision");
    }

    public HashIndex setPrecision(int precision) {
        super.set("precision", precision);
        return this;
    }

    boolean hasPrecision() {
        return super.has("precision");
    }
}

