/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosClientException;
import com.azure.cosmos.CosmosError;
import com.azure.cosmos.implementation.directconnectivity.HttpUtils;
import com.azure.cosmos.implementation.http.HttpHeaders;
import java.util.Map;

public class PreconditionFailedException
extends CosmosClientException {
    private static final long serialVersionUID = 1L;

    PreconditionFailedException() {
        this("Operation cannot be performed because one of the specified precondition is not met.");
    }

    public PreconditionFailedException(CosmosError cosmosError, long lsn, String partitionKeyRangeId, Map<String, String> responseHeaders) {
        super(412, cosmosError, responseHeaders);
        BridgeInternal.setLSN(this, lsn);
        BridgeInternal.setPartitionKeyRangeId(this, partitionKeyRangeId);
    }

    PreconditionFailedException(String msg) {
        super(412, msg);
    }

    PreconditionFailedException(String msg, String resourceAddress) {
        super(msg, null, null, 412, resourceAddress);
    }

    public PreconditionFailedException(String message, HttpHeaders headers, String requestUriString) {
        this(message, null, headers, requestUriString);
    }

    PreconditionFailedException(Exception innerException) {
        this("Operation cannot be performed because one of the specified precondition is not met.", innerException, null, null);
    }

    PreconditionFailedException(String message, Exception innerException, HttpHeaders headers, String requestUriString) {
        super(String.format("%s: %s", "Operation cannot be performed because one of the specified precondition is not met.", message), innerException, HttpUtils.asMap(headers), 412, requestUriString);
    }
}

