/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifeCycleUtils {
    private static final Logger logger = LoggerFactory.getLogger(LifeCycleUtils.class);

    public static void closeQuietly(AutoCloseable closeable) {
        try {
            if (closeable != null) {
                logger.debug("closing an instance of {}", (Object)closeable.getClass().getCanonicalName());
                closeable.close();
            }
        }
        catch (Exception e) {
            logger.warn("attempting to close an instance of {} failed", (Object)closeable.getClass().getCanonicalName(), (Object)e);
        }
    }
}

