/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.CosmosClientException;
import com.azure.cosmos.implementation.Exceptions;
import com.azure.cosmos.implementation.IDocumentClientRetryPolicy;
import com.azure.cosmos.implementation.IRetryPolicy;
import com.azure.cosmos.implementation.RequestOptions;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.caches.RxClientCollectionCache;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import reactor.core.publisher.Mono;

public class PartitionKeyMismatchRetryPolicy
implements IDocumentClientRetryPolicy {
    private RxClientCollectionCache clientCollectionCache;
    private IDocumentClientRetryPolicy nextRetryPolicy;
    private AtomicInteger retriesAttempted = new AtomicInteger(0);
    private String collectionLink;
    private RequestOptions options;
    private static final int MaxRetries = 1;

    public PartitionKeyMismatchRetryPolicy(RxClientCollectionCache clientCollectionCache, IDocumentClientRetryPolicy nextRetryPolicy, String resourceFullName, RequestOptions requestOptions) {
        this.clientCollectionCache = clientCollectionCache;
        this.nextRetryPolicy = nextRetryPolicy;
        this.collectionLink = Utils.getCollectionName(resourceFullName);
        this.options = this.options;
    }

    @Override
    public Mono<IRetryPolicy.ShouldRetryResult> shouldRetry(Exception exception) {
        CosmosClientException clientException = Utils.as(exception, CosmosClientException.class);
        if (clientException != null && Exceptions.isStatusCode(clientException, 400) && Exceptions.isSubStatusCode(clientException, 1001) && this.retriesAttempted.get() < 1) {
            if (this.options != null) {
                this.clientCollectionCache.refresh(this.collectionLink, this.options.getProperties());
            } else {
                this.clientCollectionCache.refresh(this.collectionLink, null);
            }
            this.retriesAttempted.incrementAndGet();
            return Mono.just((Object)IRetryPolicy.ShouldRetryResult.retryAfter(Duration.ZERO));
        }
        return this.nextRetryPolicy.shouldRetry(exception);
    }

    @Override
    public void onBeforeSendRequest(RxDocumentServiceRequest request) {
        this.nextRetryPolicy.onBeforeSendRequest(request);
    }
}

