/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.CosmosClientException;
import com.azure.cosmos.implementation.DocumentCollection;
import com.azure.cosmos.implementation.Exceptions;
import com.azure.cosmos.implementation.IDocumentClientRetryPolicy;
import com.azure.cosmos.implementation.IRetryPolicy;
import com.azure.cosmos.implementation.ISessionContainer;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.caches.RxClientCollectionCache;
import java.time.Duration;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class RenameCollectionAwareClientRetryPolicy
implements IDocumentClientRetryPolicy {
    private static final Logger logger = LoggerFactory.getLogger(RenameCollectionAwareClientRetryPolicy.class);
    private final IDocumentClientRetryPolicy retryPolicy;
    private final ISessionContainer sessionContainer;
    private final RxClientCollectionCache collectionCache;
    private RxDocumentServiceRequest request;
    private boolean hasTriggered = false;

    public RenameCollectionAwareClientRetryPolicy(ISessionContainer sessionContainer, RxClientCollectionCache collectionCache, IDocumentClientRetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        this.sessionContainer = sessionContainer;
        this.collectionCache = collectionCache;
        this.request = null;
    }

    @Override
    public void onBeforeSendRequest(RxDocumentServiceRequest request) {
        this.request = request;
        this.retryPolicy.onBeforeSendRequest(request);
    }

    @Override
    public Mono<IRetryPolicy.ShouldRetryResult> shouldRetry(Exception e) {
        return this.retryPolicy.shouldRetry(e).flatMap(shouldRetryResult -> {
            if (!shouldRetryResult.shouldRetry && !this.hasTriggered) {
                CosmosClientException clientException = Utils.as(e, CosmosClientException.class);
                if (this.request == null) {
                    logger.error("onBeforeSendRequest is not invoked, encountered failure due to request being null", (Throwable)e);
                    return Mono.just((Object)IRetryPolicy.ShouldRetryResult.error(e));
                }
                if (clientException != null && this.request.getIsNameBased() && Exceptions.isStatusCode(clientException, 404) && Exceptions.isSubStatusCode(clientException, 1002)) {
                    logger.warn("Clear the token for named base request {}", (Object)this.request.getResourceAddress());
                    this.sessionContainer.clearTokenByCollectionFullName(this.request.getResourceAddress());
                    this.hasTriggered = true;
                    String oldCollectionRid = this.request.requestContext.resolvedCollectionRid;
                    this.request.forceNameCacheRefresh = true;
                    this.request.requestContext.resolvedCollectionRid = null;
                    Mono<Utils.ValueHolder<DocumentCollection>> collectionObs = this.collectionCache.resolveCollectionAsync(this.request);
                    return collectionObs.flatMap(collectionValueHolder -> {
                        if (collectionValueHolder.v == null) {
                            logger.warn("Can't recover from session unavailable exception because resolving collection name {} returned null", (Object)this.request.getResourceAddress());
                        } else if (!StringUtils.isEmpty((CharSequence)oldCollectionRid) && !StringUtils.isEmpty((CharSequence)((DocumentCollection)collectionValueHolder.v).getResourceId())) {
                            return Mono.just((Object)IRetryPolicy.ShouldRetryResult.retryAfter(Duration.ZERO));
                        }
                        return Mono.just((Object)shouldRetryResult);
                    }).onErrorResume(throwable -> {
                        logger.warn("Can't recover from session unavailable exception because resolving collection name {} failed with {}", (Object)this.request.getResourceAddress(), (Object)throwable.getMessage());
                        if (throwable instanceof Exception) {
                            return Mono.just((Object)IRetryPolicy.ShouldRetryResult.error((Exception)throwable));
                        }
                        return Mono.error((Throwable)throwable);
                    });
                }
            }
            return Mono.just((Object)shouldRetryResult);
        });
    }
}

