/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdObjectMapper;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Iterator;

public final class RequestTimeline
implements Iterable<Event> {
    private static final RequestTimeline EMPTY = new RequestTimeline();
    private final ImmutableList<Event> events;

    private RequestTimeline() {
        this.events = ImmutableList.of();
    }

    private RequestTimeline(ImmutableList<Event> events) {
        Preconditions.checkNotNull(events, (Object)"expected non-null events");
        this.events = events;
    }

    public static RequestTimeline empty() {
        return EMPTY;
    }

    @Override
    public Iterator<Event> iterator() {
        return this.events.iterator();
    }

    public static RequestTimeline of() {
        return EMPTY;
    }

    public static RequestTimeline of(Event event) {
        return new RequestTimeline((ImmutableList<Event>)ImmutableList.of((Object)event));
    }

    public static RequestTimeline of(Event e1, Event e2) {
        return new RequestTimeline((ImmutableList<Event>)ImmutableList.of((Object)e1, (Object)e2));
    }

    public static RequestTimeline of(Event e1, Event e2, Event e3) {
        return new RequestTimeline((ImmutableList<Event>)ImmutableList.of((Object)e1, (Object)e2, (Object)e3));
    }

    public static RequestTimeline of(Event e1, Event e2, Event e3, Event e4) {
        return new RequestTimeline((ImmutableList<Event>)ImmutableList.of((Object)e1, (Object)e2, (Object)e3, (Object)e4));
    }

    public static RequestTimeline of(Event e1, Event e2, Event e3, Event e4, Event e5) {
        return new RequestTimeline((ImmutableList<Event>)ImmutableList.of((Object)e1, (Object)e2, (Object)e3, (Object)e4, (Object)e5));
    }

    public static RequestTimeline of(Event ... events) {
        return new RequestTimeline((ImmutableList<Event>)ImmutableList.copyOf((Object[])events));
    }

    public String toString() {
        return RntbdObjectMapper.toString(this);
    }

    @JsonPropertyOrder(value={"name", "time", "duration"})
    public static final class Event {
        @JsonSerialize(using=ToStringSerializer.class)
        private final Duration duration;
        private final String name;
        @JsonSerialize(using=ToStringSerializer.class)
        private final OffsetDateTime time;

        public Event(String name, OffsetDateTime from, OffsetDateTime to) {
            Preconditions.checkNotNull((Object)name, (Object)"expected non-null name");
            this.name = name;
            this.time = from;
            this.duration = from == null ? null : (to == null ? Duration.ZERO : Duration.between(from, to));
        }

        public Duration getDuration() {
            return this.duration;
        }

        public String getName() {
            return this.name;
        }

        public OffsetDateTime getTime() {
            return this.time;
        }
    }
}

