/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.ConnectionPolicy;
import com.azure.cosmos.RetryOptions;
import com.azure.cosmos.implementation.ClientRetryPolicy;
import com.azure.cosmos.implementation.GlobalEndpointManager;
import com.azure.cosmos.implementation.IDocumentClientRetryPolicy;
import com.azure.cosmos.implementation.IRetryPolicyFactory;

public class RetryPolicy
implements IRetryPolicyFactory {
    private final GlobalEndpointManager globalEndpointManager;
    private final boolean enableEndpointDiscovery;
    private final RetryOptions retryOptions;

    public RetryPolicy(GlobalEndpointManager globalEndpointManager, ConnectionPolicy connectionPolicy) {
        this.enableEndpointDiscovery = connectionPolicy.getEnableEndpointDiscovery();
        this.globalEndpointManager = globalEndpointManager;
        this.retryOptions = connectionPolicy.getRetryOptions();
    }

    @Override
    public IDocumentClientRetryPolicy getRequestPolicy() {
        ClientRetryPolicy clientRetryPolicy = new ClientRetryPolicy(this.globalEndpointManager, this.enableEndpointDiscovery, this.retryOptions);
        return clientRetryPolicy;
    }
}

