/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.caches;

import com.azure.cosmos.CosmosClientException;
import com.azure.cosmos.FeedOptions;
import com.azure.cosmos.NotFoundException;
import com.azure.cosmos.implementation.AsyncDocumentClient;
import com.azure.cosmos.implementation.DocumentCollection;
import com.azure.cosmos.implementation.Exceptions;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.PartitionKeyRange;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.caches.AsyncCache;
import com.azure.cosmos.implementation.caches.IPartitionKeyRangeCache;
import com.azure.cosmos.implementation.caches.RxCollectionCache;
import com.azure.cosmos.implementation.routing.CollectionRoutingMap;
import com.azure.cosmos.implementation.routing.IServerIdentity;
import com.azure.cosmos.implementation.routing.InMemoryCollectionRoutingMap;
import com.azure.cosmos.implementation.routing.Range;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RxPartitionKeyRangeCache
implements IPartitionKeyRangeCache {
    private final Logger logger = LoggerFactory.getLogger(RxPartitionKeyRangeCache.class);
    private final AsyncCache<String, CollectionRoutingMap> routingMapCache = new AsyncCache();
    private final AsyncDocumentClient client;
    private final RxCollectionCache collectionCache;

    public RxPartitionKeyRangeCache(AsyncDocumentClient client, RxCollectionCache collectionCache) {
        this.client = client;
        this.collectionCache = collectionCache;
    }

    @Override
    public Mono<Utils.ValueHolder<CollectionRoutingMap>> tryLookupAsync(String collectionRid, CollectionRoutingMap previousValue, Map<String, Object> properties) {
        return this.routingMapCache.getAsync(collectionRid, previousValue, () -> this.getRoutingMapForCollectionAsync(collectionRid, previousValue, properties)).map(Utils.ValueHolder::new).onErrorResume(err -> {
            this.logger.debug("tryLookupAsync on collectionRid {} encountered failure", (Object)collectionRid, err);
            CosmosClientException dce = Utils.as(err, CosmosClientException.class);
            if (dce != null && Exceptions.isStatusCode(dce, 404)) {
                return Mono.just(new Utils.ValueHolder<Object>(null));
            }
            return Mono.error((Throwable)err);
        });
    }

    @Override
    public Mono<Utils.ValueHolder<CollectionRoutingMap>> tryLookupAsync(String collectionRid, CollectionRoutingMap previousValue, boolean forceRefreshCollectionRoutingMap, Map<String, Object> properties) {
        return this.tryLookupAsync(collectionRid, previousValue, properties);
    }

    @Override
    public Mono<Utils.ValueHolder<List<PartitionKeyRange>>> tryGetOverlappingRangesAsync(String collectionRid, Range<String> range, boolean forceRefresh, Map<String, Object> properties) {
        Mono<Utils.ValueHolder<CollectionRoutingMap>> routingMapObs = this.tryLookupAsync(collectionRid, null, properties);
        return routingMapObs.flatMap(routingMapValueHolder -> {
            if (forceRefresh && routingMapValueHolder.v != null) {
                this.logger.debug("tryGetOverlappingRangesAsync with forceRefresh on collectionRid {}", (Object)collectionRid);
                return this.tryLookupAsync(collectionRid, (CollectionRoutingMap)routingMapValueHolder.v, properties);
            }
            return Mono.just((Object)routingMapValueHolder);
        }).map(routingMapValueHolder -> {
            if (routingMapValueHolder.v != null) {
                return new Utils.ValueHolder<ArrayList<PartitionKeyRange>>(new ArrayList<PartitionKeyRange>(((CollectionRoutingMap)routingMapValueHolder.v).getOverlappingRanges(range)));
            }
            this.logger.debug("Routing Map Null for collection: {} for range: {}, forceRefresh:{}", new Object[]{collectionRid, range, forceRefresh});
            return new Utils.ValueHolder<Object>(null);
        });
    }

    @Override
    public Mono<Utils.ValueHolder<PartitionKeyRange>> tryGetPartitionKeyRangeByIdAsync(String collectionResourceId, String partitionKeyRangeId, boolean forceRefresh, Map<String, Object> properties) {
        Mono<Utils.ValueHolder<CollectionRoutingMap>> routingMapObs = this.tryLookupAsync(collectionResourceId, null, properties);
        return routingMapObs.flatMap(routingMapValueHolder -> {
            if (forceRefresh && routingMapValueHolder.v != null) {
                return this.tryLookupAsync(collectionResourceId, (CollectionRoutingMap)routingMapValueHolder.v, properties);
            }
            return Mono.just((Object)routingMapValueHolder);
        }).map(routingMapValueHolder -> {
            if (routingMapValueHolder.v != null) {
                return new Utils.ValueHolder<PartitionKeyRange>(((CollectionRoutingMap)routingMapValueHolder.v).getRangeByPartitionKeyRangeId(partitionKeyRangeId));
            }
            this.logger.debug("Routing Map Null for collection: {}, PartitionKeyRangeId: {}, forceRefresh:{}", new Object[]{collectionResourceId, partitionKeyRangeId, forceRefresh});
            return new Utils.ValueHolder<Object>(null);
        });
    }

    @Override
    public Mono<Utils.ValueHolder<PartitionKeyRange>> tryGetRangeByPartitionKeyRangeId(String collectionRid, String partitionKeyRangeId, Map<String, Object> properties) {
        Mono routingMapObs = this.routingMapCache.getAsync(collectionRid, null, () -> this.getRoutingMapForCollectionAsync(collectionRid, null, properties)).map(Utils.ValueHolder::new);
        return routingMapObs.map(routingMapValueHolder -> new Utils.ValueHolder<PartitionKeyRange>(((CollectionRoutingMap)routingMapValueHolder.v).getRangeByPartitionKeyRangeId(partitionKeyRangeId))).onErrorResume(err -> {
            CosmosClientException dce = Utils.as(err, CosmosClientException.class);
            this.logger.debug("tryGetRangeByPartitionKeyRangeId on collectionRid {} and partitionKeyRangeId {} encountered failure", new Object[]{collectionRid, partitionKeyRangeId, err});
            if (dce != null && Exceptions.isStatusCode(dce, 404)) {
                return Mono.just(new Utils.ValueHolder<Object>(null));
            }
            return Mono.error((Throwable)dce);
        });
    }

    private Mono<CollectionRoutingMap> getRoutingMapForCollectionAsync(String collectionRid, CollectionRoutingMap previousRoutingMap, Map<String, Object> properties) {
        Mono<List<PartitionKeyRange>> rangesObs = this.getPartitionKeyRange(collectionRid, false, properties);
        return rangesObs.flatMap(ranges -> {
            CollectionRoutingMap routingMap;
            List<ImmutablePair<PartitionKeyRange, IServerIdentity>> rangesTuples = ranges.stream().map(range -> new ImmutablePair(range, (Object)null)).collect(Collectors.toList());
            if (previousRoutingMap == null) {
                HashSet goneRanges = new HashSet(ranges.stream().flatMap(range -> CollectionUtils.emptyIfNull(range.getParents()).stream()).collect(Collectors.toSet()));
                routingMap = InMemoryCollectionRoutingMap.tryCreateCompleteRoutingMap(rangesTuples.stream().filter(tuple -> !goneRanges.contains(((PartitionKeyRange)tuple.left).getId())).collect(Collectors.toList()), collectionRid);
            } else {
                routingMap = previousRoutingMap.tryCombine(rangesTuples);
            }
            if (routingMap == null) {
                return Mono.error((Throwable)new NotFoundException(String.format("GetRoutingMapForCollectionAsync(collectionRid: {%s}), RANGE information either doesn't exist or is not complete.", collectionRid)));
            }
            return Mono.just((Object)routingMap);
        });
    }

    private Mono<List<PartitionKeyRange>> getPartitionKeyRange(String collectionRid, boolean forceRefresh, Map<String, Object> properties) {
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.ReadFeed, collectionRid, ResourceType.PartitionKeyRange, null);
        request.requestContext.resolvedCollectionRid = collectionRid;
        Mono collectionObs = this.collectionCache.resolveCollectionAsync(request).map(collectionValueHolder -> (DocumentCollection)collectionValueHolder.v);
        return collectionObs.flatMap(coll -> {
            FeedOptions feedOptions = new FeedOptions();
            if (properties != null) {
                feedOptions.properties(properties);
            }
            return this.client.readPartitionKeyRanges(coll.getSelfLink(), feedOptions).flatMap(p -> Flux.fromIterable(p.getResults()), 1).collectList();
        });
    }
}

