/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.changefeed.implementation;

import com.azure.cosmos.CosmosItemProperties;
import com.azure.cosmos.implementation.changefeed.ChangeFeedObserver;
import com.azure.cosmos.implementation.changefeed.ChangeFeedObserverCloseReason;
import com.azure.cosmos.implementation.changefeed.ChangeFeedObserverContext;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

class DefaultObserver
implements ChangeFeedObserver {
    private static final Logger log = LoggerFactory.getLogger(DefaultObserver.class);
    private final Consumer<List<CosmosItemProperties>> consumer;

    public DefaultObserver(Consumer<List<CosmosItemProperties>> consumer) {
        this.consumer = consumer;
    }

    @Override
    public void open(ChangeFeedObserverContext context) {
        log.info("Open processing from thread {}", (Object)Thread.currentThread().getId());
    }

    @Override
    public void close(ChangeFeedObserverContext context, ChangeFeedObserverCloseReason reason) {
        log.info("Close processing from thread {}", (Object)Thread.currentThread().getId());
    }

    @Override
    public Mono<Void> processChanges(ChangeFeedObserverContext context, List<CosmosItemProperties> docs) {
        log.info("Start processing from thread {}", (Object)Thread.currentThread().getId());
        try {
            this.consumer.accept(docs);
            log.info("Done processing from thread {}", (Object)Thread.currentThread().getId());
        }
        catch (Exception ex) {
            log.warn("Unexpected exception thrown from thread {}", (Object)Thread.currentThread().getId(), (Object)ex);
            return Mono.error((Throwable)ex);
        }
        return Mono.empty();
    }
}

