/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosClientException;
import com.azure.cosmos.CosmosError;
import com.azure.cosmos.implementation.RxDocumentServiceResponse;
import com.azure.cosmos.implementation.directconnectivity.ResponseUtils;
import com.azure.cosmos.implementation.http.HttpRequest;
import com.azure.cosmos.implementation.http.HttpResponse;
import reactor.core.publisher.Mono;

public class HttpClientUtils {
    static Mono<RxDocumentServiceResponse> parseResponseAsync(Mono<HttpResponse> httpResponse, HttpRequest httpRequest) {
        return httpResponse.flatMap(response -> {
            if (response.statusCode() < 400) {
                return ResponseUtils.toStoreResponse(response, httpRequest).map(RxDocumentServiceResponse::new);
            }
            return HttpClientUtils.createDocumentClientException(response).flatMap(Mono::error);
        });
    }

    private static Mono<CosmosClientException> createDocumentClientException(HttpResponse httpResponse) {
        Mono readStream = httpResponse.bodyAsString().switchIfEmpty(Mono.just((Object)""));
        return readStream.map(body -> {
            CosmosError cosmosError = BridgeInternal.createCosmosError(body);
            return BridgeInternal.createCosmosClientException(httpResponse.statusCode(), cosmosError, httpResponse.headers().toMap());
        });
    }
}

