/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity.rntbd;

import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdRequest;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdRequestArgs;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RntbdRequestEncoder
extends MessageToByteEncoder {
    private static final Logger logger = LoggerFactory.getLogger(RntbdRequestEncoder.class);

    public boolean acceptOutboundMessage(Object message) {
        return message instanceof RntbdRequestArgs;
    }

    protected void encode(ChannelHandlerContext context, Object message, ByteBuf out) throws Exception {
        RntbdRequest request = RntbdRequest.from((RntbdRequestArgs)message);
        int start = out.writerIndex();
        try {
            request.encode(out);
        }
        catch (Throwable error) {
            out.writerIndex(start);
            throw error;
        }
        if (logger.isDebugEnabled()) {
            int length = out.writerIndex() - start;
            logger.debug("{}: ENCODE COMPLETE: length={}, request={}", new Object[]{context.channel(), length, request});
        }
    }
}

