/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.FeedOptions;
import com.azure.cosmos.FeedResponse;
import com.azure.cosmos.Resource;
import com.azure.cosmos.SqlQuerySpec;
import com.azure.cosmos.implementation.PartitionKeyRange;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.query.AggregateDocumentQueryExecutionContext;
import com.azure.cosmos.implementation.query.IDocumentQueryClient;
import com.azure.cosmos.implementation.query.IDocumentQueryExecutionComponent;
import com.azure.cosmos.implementation.query.IDocumentQueryExecutionContext;
import com.azure.cosmos.implementation.query.OrderByDocumentQueryExecutionContext;
import com.azure.cosmos.implementation.query.ParallelDocumentQueryExecutionContext;
import com.azure.cosmos.implementation.query.PartitionedQueryExecutionInfo;
import com.azure.cosmos.implementation.query.QueryInfo;
import com.azure.cosmos.implementation.query.SkipDocumentQueryExecutionContext;
import com.azure.cosmos.implementation.query.TopDocumentQueryExecutionContext;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import reactor.core.publisher.Flux;

public class PipelinedDocumentQueryExecutionContext<T extends Resource>
implements IDocumentQueryExecutionContext<T> {
    private IDocumentQueryExecutionComponent<T> component;
    private int actualPageSize;
    private UUID correlatedActivityId;

    private PipelinedDocumentQueryExecutionContext(IDocumentQueryExecutionComponent<T> component, int actualPageSize, UUID correlatedActivityId) {
        this.component = component;
        this.actualPageSize = actualPageSize;
        this.correlatedActivityId = correlatedActivityId;
    }

    public static <T extends Resource> Flux<PipelinedDocumentQueryExecutionContext<T>> createAsync(IDocumentQueryClient client, ResourceType resourceTypeEnum, Class<T> resourceType, SqlQuerySpec expression, FeedOptions feedOptions, String resourceLink, String collectionRid, PartitionedQueryExecutionInfo partitionedQueryExecutionInfo, List<PartitionKeyRange> targetRanges, int initialPageSize, boolean isContinuationExpected, boolean getLazyFeedResponse, UUID correlatedActivityId) {
        QueryInfo queryInfo = partitionedQueryExecutionInfo.getQueryInfo();
        Function<String, Flux> createBaseComponentFunction = queryInfo.hasOrderBy() ? continuationToken -> {
            FeedOptions orderByFeedOptions = new FeedOptions(feedOptions);
            orderByFeedOptions.requestContinuation((String)continuationToken);
            return OrderByDocumentQueryExecutionContext.createAsync(client, resourceTypeEnum, resourceType, expression, orderByFeedOptions, resourceLink, collectionRid, partitionedQueryExecutionInfo, targetRanges, initialPageSize, isContinuationExpected, getLazyFeedResponse, correlatedActivityId);
        } : continuationToken -> {
            FeedOptions parallelFeedOptions = new FeedOptions(feedOptions);
            parallelFeedOptions.requestContinuation((String)continuationToken);
            return ParallelDocumentQueryExecutionContext.createAsync(client, resourceTypeEnum, resourceType, expression, parallelFeedOptions, resourceLink, collectionRid, partitionedQueryExecutionInfo, targetRanges, initialPageSize, isContinuationExpected, getLazyFeedResponse, correlatedActivityId);
        };
        Function<String, Flux> createAggregateComponentFunction = queryInfo.hasAggregates() ? continuationToken -> AggregateDocumentQueryExecutionContext.createAsync(createBaseComponentFunction, queryInfo.getAggregates(), continuationToken) : createBaseComponentFunction;
        Function<String, Flux> createSkipComponentFunction = queryInfo.hasOffset() ? continuationToken -> SkipDocumentQueryExecutionContext.createAsync(createAggregateComponentFunction, queryInfo.getOffset(), continuationToken) : createAggregateComponentFunction;
        Function<String, Flux> createTopComponentFunction = queryInfo.hasTop() ? continuationToken -> TopDocumentQueryExecutionContext.createAsync(createSkipComponentFunction, queryInfo.getTop(), queryInfo.getTop(), continuationToken) : createSkipComponentFunction;
        Function<String, Flux> createTakeComponentFunction = queryInfo.hasLimit() ? continuationToken -> {
            int totalLimit = queryInfo.getLimit();
            if (queryInfo.hasOffset()) {
                totalLimit = queryInfo.getOffset() + queryInfo.getLimit();
            }
            return TopDocumentQueryExecutionContext.createAsync(createTopComponentFunction, queryInfo.getLimit(), totalLimit, continuationToken);
        } : createTopComponentFunction;
        int actualPageSize = Utils.getValueOrDefault(feedOptions.maxItemCount(), 100);
        if (actualPageSize == -1) {
            actualPageSize = Integer.MAX_VALUE;
        }
        int pageSize = Math.min(actualPageSize, Utils.getValueOrDefault(queryInfo.getTop(), actualPageSize));
        return createTakeComponentFunction.apply(feedOptions.requestContinuation()).map(c -> new PipelinedDocumentQueryExecutionContext(c, pageSize, correlatedActivityId));
    }

    @Override
    public Flux<FeedResponse<T>> executeAsync() {
        return this.component.drainAsync(this.actualPageSize);
    }
}

