/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.routing;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.DatabaseAccount;
import com.azure.cosmos.DatabaseAccountLocation;
import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.Utils;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.commons.collections4.list.UnmodifiableList;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.apache.commons.collections4.map.UnmodifiableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationCache {
    private static final Logger logger = LoggerFactory.getLogger(LocationCache.class);
    private final boolean enableEndpointDiscovery;
    private final URI defaultEndpoint;
    private final boolean useMultipleWriteLocations;
    private final Object lockObject;
    private final Duration unavailableLocationsExpirationTime;
    private final ConcurrentHashMap<URI, LocationUnavailabilityInfo> locationUnavailabilityInfoByEndpoint;
    private DatabaseAccountLocationsInfo locationInfo;
    private Instant lastCacheUpdateTimestamp;
    private boolean enableMultipleWriteLocations;

    public LocationCache(List<String> preferredLocations, URI defaultEndpoint, boolean enableEndpointDiscovery, boolean useMultipleWriteLocations, Configs configs) {
        this.locationInfo = new DatabaseAccountLocationsInfo(preferredLocations, defaultEndpoint);
        this.defaultEndpoint = defaultEndpoint;
        this.enableEndpointDiscovery = enableEndpointDiscovery;
        this.useMultipleWriteLocations = useMultipleWriteLocations;
        this.lockObject = new Object();
        this.locationUnavailabilityInfoByEndpoint = new ConcurrentHashMap();
        this.lastCacheUpdateTimestamp = Instant.MIN;
        this.enableMultipleWriteLocations = false;
        this.unavailableLocationsExpirationTime = Duration.ofSeconds(configs.getUnavailableLocationsExpirationTimeInSeconds());
    }

    public UnmodifiableList<URI> getReadEndpoints() {
        if (this.locationUnavailabilityInfoByEndpoint.size() > 0 && this.unavailableLocationsExpirationTimePassed()) {
            this.updateLocationCache();
        }
        return this.locationInfo.readEndpoints;
    }

    public UnmodifiableList<URI> getWriteEndpoints() {
        if (this.locationUnavailabilityInfoByEndpoint.size() > 0 && this.unavailableLocationsExpirationTimePassed()) {
            this.updateLocationCache();
        }
        return this.locationInfo.writeEndpoints;
    }

    public void markEndpointUnavailableForRead(URI endpoint) {
        this.markEndpointUnavailable(endpoint, OperationType.Read);
    }

    public void markEndpointUnavailableForWrite(URI endpoint) {
        this.markEndpointUnavailable(endpoint, OperationType.Write);
    }

    public void onDatabaseAccountRead(DatabaseAccount databaseAccount) {
        this.updateLocationCache(databaseAccount.getWritableLocations(), databaseAccount.getReadableLocations(), null, BridgeInternal.isEnableMultipleWriteLocations(databaseAccount));
    }

    void onLocationPreferenceChanged(UnmodifiableList<String> preferredLocations) {
        this.updateLocationCache(null, null, preferredLocations, null);
    }

    public URI resolveServiceEndpoint(RxDocumentServiceRequest request) {
        boolean usePreferredLocations;
        if (request.requestContext != null && request.requestContext.locationEndpointToRoute != null) {
            return request.requestContext.locationEndpointToRoute;
        }
        int locationIndex = Utils.getValueOrDefault(request.requestContext.locationIndexToRoute, 0);
        boolean bl = usePreferredLocations = request.requestContext.usePreferredLocations != null ? request.requestContext.usePreferredLocations : true;
        if (!usePreferredLocations || request.getOperationType().isWriteOperation() && !this.canUseMultipleWriteLocations(request)) {
            DatabaseAccountLocationsInfo currentLocationInfo = this.locationInfo;
            if (this.enableEndpointDiscovery && currentLocationInfo.availableWriteLocations.size() > 0) {
                locationIndex = Math.min(locationIndex % 2, currentLocationInfo.availableWriteLocations.size() - 1);
                String writeLocation = (String)currentLocationInfo.availableWriteLocations.get(locationIndex);
                return (URI)currentLocationInfo.availableWriteEndpointByLocation.get((Object)writeLocation);
            }
            return this.defaultEndpoint;
        }
        UnmodifiableList<URI> endpoints = request.getOperationType().isWriteOperation() ? this.getWriteEndpoints() : this.getReadEndpoints();
        return (URI)endpoints.get(locationIndex % endpoints.size());
    }

    public boolean shouldRefreshEndpoints(Utils.ValueHolder canRefreshInBackground) {
        canRefreshInBackground.v = true;
        DatabaseAccountLocationsInfo currentLocationInfo = this.locationInfo;
        String mostPreferredLocation = (String)Utils.firstOrDefault(currentLocationInfo.preferredLocations);
        if (this.enableEndpointDiscovery) {
            boolean shouldRefresh = this.useMultipleWriteLocations && !this.enableMultipleWriteLocations;
            UnmodifiableList readLocationEndpoints = currentLocationInfo.readEndpoints;
            if (this.isEndpointUnavailable((URI)readLocationEndpoints.get(0), OperationType.Read)) {
                canRefreshInBackground.v = this.anyEndpointsAvailable((List<URI>)readLocationEndpoints, OperationType.Read);
                logger.debug("shouldRefreshEndpoints = true,  since the first read endpoint [{}] is not available for read. canRefreshInBackground = [{}]", readLocationEndpoints.get(0), canRefreshInBackground.v);
                return true;
            }
            if (!Strings.isNullOrEmpty(mostPreferredLocation)) {
                Utils.ValueHolder mostPreferredReadEndpointHolder = new Utils.ValueHolder();
                logger.debug("getReadEndpoints [{}]", (Object)readLocationEndpoints);
                if (Utils.tryGetValue(currentLocationInfo.availableReadEndpointByLocation, mostPreferredLocation, mostPreferredReadEndpointHolder)) {
                    logger.debug("most preferred is [{}], most preferred available is [{}]", (Object)mostPreferredLocation, mostPreferredReadEndpointHolder.v);
                    if (!this.areEqual((URI)mostPreferredReadEndpointHolder.v, (URI)readLocationEndpoints.get(0))) {
                        logger.debug("shouldRefreshEndpoints = true, most preferred location [{}] is not available for read.", (Object)mostPreferredLocation);
                        return true;
                    }
                    logger.debug("most preferred is [{}], and most preferred available [{}] are the same", (Object)mostPreferredLocation, mostPreferredReadEndpointHolder.v);
                } else {
                    logger.debug("shouldRefreshEndpoints = true, most preferred location [{}] is not in available read locations.", (Object)mostPreferredLocation);
                    return true;
                }
            }
            Utils.ValueHolder mostPreferredWriteEndpointHolder = new Utils.ValueHolder();
            UnmodifiableList writeLocationEndpoints = currentLocationInfo.writeEndpoints;
            logger.debug("getWriteEndpoints [{}]", (Object)writeLocationEndpoints);
            if (!this.canUseMultipleWriteLocations()) {
                if (this.isEndpointUnavailable((URI)writeLocationEndpoints.get(0), OperationType.Write)) {
                    canRefreshInBackground.v = this.anyEndpointsAvailable((List<URI>)writeLocationEndpoints, OperationType.Write);
                    logger.debug("shouldRefreshEndpoints = true, most preferred location [{}] endpoint [{}] is not available for write. canRefreshInBackground = [{}]", new Object[]{mostPreferredLocation, writeLocationEndpoints.get(0), canRefreshInBackground.v});
                    return true;
                }
                logger.debug("shouldRefreshEndpoints: false, [{}] is available for Write", writeLocationEndpoints.get(0));
                return shouldRefresh;
            }
            if (!Strings.isNullOrEmpty(mostPreferredLocation)) {
                if (Utils.tryGetValue(currentLocationInfo.availableWriteEndpointByLocation, mostPreferredLocation, mostPreferredWriteEndpointHolder)) {
                    boolean bl = shouldRefresh = !this.areEqual((URI)mostPreferredWriteEndpointHolder.v, (URI)writeLocationEndpoints.get(0));
                    if (shouldRefresh) {
                        logger.debug("shouldRefreshEndpoints: true, write endpoint [{}] is not the same as most preferred [{}]", writeLocationEndpoints.get(0), mostPreferredWriteEndpointHolder.v);
                    } else {
                        logger.debug("shouldRefreshEndpoints: false, write endpoint [{}] is the same as most preferred [{}]", writeLocationEndpoints.get(0), mostPreferredWriteEndpointHolder.v);
                    }
                    return shouldRefresh;
                }
                logger.debug("shouldRefreshEndpoints = true, most preferred location [{}] is not in available write locations", (Object)mostPreferredLocation);
                return true;
            }
            logger.debug("shouldRefreshEndpoints: false, mostPreferredLocation [{}] is empty", (Object)mostPreferredLocation);
            return shouldRefresh;
        }
        logger.debug("shouldRefreshEndpoints: false, endpoint discovery not enabled");
        return false;
    }

    private boolean areEqual(URI url1, URI url2) {
        return url1.equals(url2);
    }

    private void clearStaleEndpointUnavailabilityInfo() {
        if (!this.locationUnavailabilityInfoByEndpoint.isEmpty()) {
            ArrayList unavailableEndpoints = new ArrayList(this.locationUnavailabilityInfoByEndpoint.keySet());
            for (URI unavailableEndpoint : unavailableEndpoints) {
                Utils.ValueHolder unavailabilityInfoHolder = new Utils.ValueHolder();
                Utils.ValueHolder removedHolder = new Utils.ValueHolder();
                if (!Utils.tryGetValue(this.locationUnavailabilityInfoByEndpoint, unavailableEndpoint, unavailabilityInfoHolder) || !this.durationPassed(Instant.now(), ((LocationUnavailabilityInfo)unavailabilityInfoHolder.v).LastUnavailabilityCheckTimeStamp, this.unavailableLocationsExpirationTime) || !Utils.tryRemove(this.locationUnavailabilityInfoByEndpoint, unavailableEndpoint, removedHolder)) continue;
                logger.debug("Removed endpoint [{}] unavailable for operations [{}] from unavailableEndpoints", (Object)unavailableEndpoint, (Object)((LocationUnavailabilityInfo)unavailabilityInfoHolder.v).UnavailableOperations);
            }
        }
    }

    private boolean isEndpointUnavailable(URI endpoint, OperationType expectedAvailableOperations) {
        Utils.ValueHolder unavailabilityInfoHolder = new Utils.ValueHolder();
        if (expectedAvailableOperations == OperationType.None || !Utils.tryGetValue(this.locationUnavailabilityInfoByEndpoint, endpoint, unavailabilityInfoHolder) || !((LocationUnavailabilityInfo)unavailabilityInfoHolder.v).UnavailableOperations.supports(expectedAvailableOperations)) {
            return false;
        }
        if (this.durationPassed(Instant.now(), ((LocationUnavailabilityInfo)unavailabilityInfoHolder.v).LastUnavailabilityCheckTimeStamp, this.unavailableLocationsExpirationTime)) {
            return false;
        }
        logger.debug("Endpoint [{}] unavailable for operations [{}] present in unavailableEndpoints", (Object)endpoint, (Object)((LocationUnavailabilityInfo)unavailabilityInfoHolder.v).UnavailableOperations);
        return true;
    }

    private boolean anyEndpointsAvailable(List<URI> endpoints, OperationType expectedAvailableOperations) {
        Utils.ValueHolder unavailabilityInfoHolder = new Utils.ValueHolder();
        boolean anyEndpointsAvailable = false;
        for (URI endpoint : endpoints) {
            if (this.isEndpointUnavailable(endpoint, expectedAvailableOperations)) continue;
            anyEndpointsAvailable = true;
            break;
        }
        return anyEndpointsAvailable;
    }

    private void markEndpointUnavailable(URI unavailableEndpoint, final OperationType unavailableOperationType) {
        final Instant currentTime = Instant.now();
        LocationUnavailabilityInfo updatedInfo = this.locationUnavailabilityInfoByEndpoint.compute(unavailableEndpoint, new BiFunction<URI, LocationUnavailabilityInfo, LocationUnavailabilityInfo>(){

            @Override
            public LocationUnavailabilityInfo apply(URI url, LocationUnavailabilityInfo info) {
                if (info == null) {
                    return new LocationUnavailabilityInfo(currentTime, unavailableOperationType);
                }
                info.LastUnavailabilityCheckTimeStamp = currentTime;
                info.UnavailableOperations = OperationType.combine(info.UnavailableOperations, unavailableOperationType);
                return info;
            }
        });
        this.updateLocationCache();
        logger.debug("Endpoint [{}] unavailable for [{}] added/updated to unavailableEndpoints with timestamp [{}]", new Object[]{unavailableEndpoint, unavailableOperationType, updatedInfo.LastUnavailabilityCheckTimeStamp});
    }

    private void updateLocationCache() {
        this.updateLocationCache(null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLocationCache(Iterable<DatabaseAccountLocation> writeLocations, Iterable<DatabaseAccountLocation> readLocations, UnmodifiableList<String> preferenceList, Boolean enableMultipleWriteLocations) {
        Object object = this.lockObject;
        synchronized (object) {
            Utils.ValueHolder<UnmodifiableList<String>> out;
            DatabaseAccountLocationsInfo nextLocationInfo = new DatabaseAccountLocationsInfo(this.locationInfo);
            logger.debug("updating location cache ..., current readLocations [{}], current writeLocations [{}]", (Object)nextLocationInfo.readEndpoints, (Object)nextLocationInfo.writeEndpoints);
            if (preferenceList != null) {
                nextLocationInfo.preferredLocations = preferenceList;
            }
            if (enableMultipleWriteLocations != null) {
                this.enableMultipleWriteLocations = enableMultipleWriteLocations;
            }
            this.clearStaleEndpointUnavailabilityInfo();
            if (readLocations != null) {
                out = Utils.ValueHolder.initialize(nextLocationInfo.availableReadLocations);
                nextLocationInfo.availableReadEndpointByLocation = this.getEndpointByLocation(readLocations, out);
                nextLocationInfo.availableReadLocations = (UnmodifiableList)out.v;
            }
            if (writeLocations != null) {
                out = Utils.ValueHolder.initialize(nextLocationInfo.availableWriteLocations);
                nextLocationInfo.availableWriteEndpointByLocation = this.getEndpointByLocation(writeLocations, out);
                nextLocationInfo.availableWriteLocations = (UnmodifiableList)out.v;
            }
            nextLocationInfo.writeEndpoints = this.getPreferredAvailableEndpoints((UnmodifiableMap<String, URI>)nextLocationInfo.availableWriteEndpointByLocation, (UnmodifiableList<String>)nextLocationInfo.availableWriteLocations, OperationType.Write, this.defaultEndpoint);
            nextLocationInfo.readEndpoints = this.getPreferredAvailableEndpoints((UnmodifiableMap<String, URI>)nextLocationInfo.availableReadEndpointByLocation, (UnmodifiableList<String>)nextLocationInfo.availableReadLocations, OperationType.Read, (URI)nextLocationInfo.writeEndpoints.get(0));
            this.lastCacheUpdateTimestamp = Instant.now();
            logger.debug("updating location cache finished, new readLocations [{}], new writeLocations [{}]", (Object)nextLocationInfo.readEndpoints, (Object)nextLocationInfo.writeEndpoints);
            this.locationInfo = nextLocationInfo;
        }
    }

    private UnmodifiableList<URI> getPreferredAvailableEndpoints(UnmodifiableMap<String, URI> endpointsByLocation, UnmodifiableList<String> orderedLocations, OperationType expectedAvailableOperation, URI fallbackEndpoint) {
        ArrayList<Object> endpoints = new ArrayList<Object>();
        DatabaseAccountLocationsInfo currentLocationInfo = this.locationInfo;
        if (this.enableEndpointDiscovery) {
            if (this.canUseMultipleWriteLocations() || expectedAvailableOperation.supports(OperationType.Read)) {
                ArrayList unavailableEndpoints = new ArrayList();
                for (String location : currentLocationInfo.preferredLocations) {
                    Utils.ValueHolder endpoint;
                    if (!Utils.tryGetValue(endpointsByLocation, location, endpoint = new Utils.ValueHolder())) continue;
                    if (this.isEndpointUnavailable((URI)endpoint.v, expectedAvailableOperation)) {
                        unavailableEndpoints.add(endpoint.v);
                        continue;
                    }
                    endpoints.add(endpoint.v);
                }
                if (endpoints.isEmpty()) {
                    endpoints.add(fallbackEndpoint);
                }
                endpoints.addAll(unavailableEndpoints);
            } else {
                for (String location : orderedLocations) {
                    Utils.ValueHolder<Object> endpoint = Utils.ValueHolder.initialize(null);
                    if (Strings.isNullOrEmpty(location) || !Utils.tryGetValue(endpointsByLocation, location, endpoint)) continue;
                    endpoints.add(endpoint.v);
                }
            }
        }
        if (endpoints.isEmpty()) {
            endpoints.add(fallbackEndpoint);
        }
        return new UnmodifiableList(endpoints);
    }

    private UnmodifiableMap<String, URI> getEndpointByLocation(Iterable<DatabaseAccountLocation> locations, Utils.ValueHolder<UnmodifiableList<String>> orderedLocations) {
        CaseInsensitiveMap endpointsByLocation = new CaseInsensitiveMap();
        ArrayList<String> parsedLocations = new ArrayList<String>();
        for (DatabaseAccountLocation location : locations) {
            if (Strings.isNullOrEmpty(location.getName())) continue;
            try {
                URI endpoint = new URI(location.getEndpoint().toLowerCase());
                endpointsByLocation.put(location.getName().toLowerCase(), endpoint);
                parsedLocations.add(location.getName());
            }
            catch (Exception e) {
                logger.warn("GetAvailableEndpointsByLocation() - skipping add for location = [{}] as it is location name is either empty or endpoint is malformed [{}]", (Object)location.getName(), (Object)location.getEndpoint());
            }
        }
        orderedLocations.v = new UnmodifiableList(parsedLocations);
        return (UnmodifiableMap)UnmodifiableMap.unmodifiableMap((Map)endpointsByLocation);
    }

    private boolean canUseMultipleWriteLocations() {
        return this.useMultipleWriteLocations && this.enableMultipleWriteLocations;
    }

    public boolean canUseMultipleWriteLocations(RxDocumentServiceRequest request) {
        return this.canUseMultipleWriteLocations() && (request.getResourceType() == ResourceType.Document || request.getResourceType() == ResourceType.StoredProcedure && request.getOperationType() == com.azure.cosmos.implementation.OperationType.ExecuteJavaScript);
    }

    private boolean durationPassed(Instant end, Instant start, Duration duration) {
        return end.minus(duration).isAfter(start);
    }

    private boolean unavailableLocationsExpirationTimePassed() {
        return this.durationPassed(Instant.now(), this.lastCacheUpdateTimestamp, this.unavailableLocationsExpirationTime);
    }

    class DatabaseAccountLocationsInfo {
        private UnmodifiableList<String> preferredLocations;
        private UnmodifiableList<String> availableWriteLocations;
        private UnmodifiableList<String> availableReadLocations;
        private UnmodifiableMap<String, URI> availableWriteEndpointByLocation;
        private UnmodifiableMap<String, URI> availableReadEndpointByLocation;
        private UnmodifiableList<URI> writeEndpoints;
        private UnmodifiableList<URI> readEndpoints;

        public DatabaseAccountLocationsInfo(List<String> preferredLocations, URI defaultEndpoint) {
            this.preferredLocations = new UnmodifiableList(preferredLocations.stream().map(loc -> loc.toLowerCase()).collect(Collectors.toList()));
            this.availableWriteEndpointByLocation = (UnmodifiableMap)UnmodifiableMap.unmodifiableMap((Map)new CaseInsensitiveMap());
            this.availableReadEndpointByLocation = (UnmodifiableMap)UnmodifiableMap.unmodifiableMap((Map)new CaseInsensitiveMap());
            this.availableReadLocations = new UnmodifiableList(Collections.emptyList());
            this.availableWriteLocations = new UnmodifiableList(Collections.emptyList());
            this.readEndpoints = new UnmodifiableList(Collections.singletonList(defaultEndpoint));
            this.writeEndpoints = new UnmodifiableList(Collections.singletonList(defaultEndpoint));
        }

        public DatabaseAccountLocationsInfo(DatabaseAccountLocationsInfo other) {
            this.preferredLocations = other.preferredLocations;
            this.availableWriteLocations = other.availableWriteLocations;
            this.availableReadLocations = other.availableReadLocations;
            this.availableWriteEndpointByLocation = other.availableWriteEndpointByLocation;
            this.availableReadEndpointByLocation = other.availableReadEndpointByLocation;
            this.writeEndpoints = other.writeEndpoints;
            this.readEndpoints = other.readEndpoints;
        }
    }

    private static enum OperationType {
        None(0),
        Read(1),
        Write(2),
        ReadAndWrite(3);

        private final int flag;

        public boolean hasReadFlag() {
            return (this.flag & OperationType.Read.flag) != 0;
        }

        public boolean hasWriteFlag() {
            return (this.flag & OperationType.Write.flag) != 0;
        }

        public static OperationType combine(OperationType t1, OperationType t2) {
            switch (t1.flag | t2.flag) {
                case 0: {
                    return None;
                }
                case 1: {
                    return Read;
                }
                case 2: {
                    return Write;
                }
            }
            return ReadAndWrite;
        }

        public boolean supports(OperationType type) {
            return (this.flag & type.flag) != 0;
        }

        private OperationType(int flag) {
            this.flag = flag;
        }
    }

    private class LocationUnavailabilityInfo {
        public Instant LastUnavailabilityCheckTimeStamp;
        public OperationType UnavailableOperations;

        LocationUnavailabilityInfo(Instant instant, OperationType type) {
            this.LastUnavailabilityCheckTimeStamp = instant;
            this.UnavailableOperations = type;
        }
    }
}

