/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.ConflictResolutionMode;
import com.azure.cosmos.JsonSerializable;
import com.azure.cosmos.internal.Strings;

public class ConflictResolutionPolicy
extends JsonSerializable {
    public static ConflictResolutionPolicy createLastWriterWinsPolicy() {
        ConflictResolutionPolicy policy = new ConflictResolutionPolicy();
        policy.setMode(ConflictResolutionMode.LAST_WRITER_WINS);
        return policy;
    }

    public static ConflictResolutionPolicy createLastWriterWinsPolicy(String conflictResolutionPath) {
        ConflictResolutionPolicy policy = new ConflictResolutionPolicy();
        policy.setMode(ConflictResolutionMode.LAST_WRITER_WINS);
        if (conflictResolutionPath != null) {
            policy.setConflictResolutionPath(conflictResolutionPath);
        }
        return policy;
    }

    public static ConflictResolutionPolicy createCustomPolicy(String conflictResolutionSprocName) {
        ConflictResolutionPolicy policy = new ConflictResolutionPolicy();
        policy.setMode(ConflictResolutionMode.CUSTOM);
        if (conflictResolutionSprocName != null) {
            policy.setConflictResolutionProcedure(conflictResolutionSprocName);
        }
        return policy;
    }

    public static ConflictResolutionPolicy createCustomPolicy() {
        ConflictResolutionPolicy policy = new ConflictResolutionPolicy();
        policy.setMode(ConflictResolutionMode.CUSTOM);
        return policy;
    }

    ConflictResolutionPolicy() {
    }

    public ConflictResolutionPolicy(String jsonString) {
        super(jsonString);
    }

    public ConflictResolutionMode getMode() {
        String strValue = super.getString("mode");
        if (!Strings.isNullOrEmpty(strValue)) {
            try {
                return ConflictResolutionMode.valueOf(Strings.fromCamelCaseToUpperCase(super.getString("mode")));
            }
            catch (IllegalArgumentException e) {
                this.getLogger().warn("INVALID ConflictResolutionMode getValue {}.", (Object)super.getString("mode"));
                return ConflictResolutionMode.INVALID;
            }
        }
        return ConflictResolutionMode.INVALID;
    }

    ConflictResolutionPolicy setMode(ConflictResolutionMode mode) {
        super.set("mode", mode.toString());
        return this;
    }

    public String getConflictResolutionPath() {
        return super.getString("conflictResolutionPath");
    }

    ConflictResolutionPolicy setConflictResolutionPath(String value) {
        super.set("conflictResolutionPath", value);
        return this;
    }

    public String getConflictResolutionProcedure() {
        return super.getString("conflictResolutionProcedure");
    }

    ConflictResolutionPolicy setConflictResolutionProcedure(String value) {
        super.set("conflictResolutionProcedure", value);
        return this;
    }
}

