/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.ConnectionPolicy;
import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.CosmosAsyncDatabase;
import com.azure.cosmos.CosmosAsyncDatabaseResponse;
import com.azure.cosmos.CosmosClientBuilder;
import com.azure.cosmos.CosmosClientException;
import com.azure.cosmos.CosmosDatabaseProperties;
import com.azure.cosmos.CosmosDatabaseRequestOptions;
import com.azure.cosmos.CosmosKeyCredential;
import com.azure.cosmos.DatabaseAccount;
import com.azure.cosmos.FeedOptions;
import com.azure.cosmos.FeedResponse;
import com.azure.cosmos.SqlQuerySpec;
import com.azure.cosmos.TokenResolver;
import com.azure.cosmos.internal.AsyncDocumentClient;
import com.azure.cosmos.internal.Configs;
import com.azure.cosmos.internal.Database;
import com.azure.cosmos.internal.Permission;
import com.azure.cosmos.internal.ResourceResponse;
import com.azure.cosmos.internal.directconnectivity.rntbd.RntbdMetrics;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.List;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CosmosAsyncClient
implements AutoCloseable {
    private final Configs configs;
    private final AsyncDocumentClient asyncDocumentClient;
    private final String serviceEndpoint;
    private final String keyOrResourceToken;
    private final ConnectionPolicy connectionPolicy;
    private final ConsistencyLevel desiredConsistencyLevel;
    private final List<Permission> permissions;
    private final TokenResolver tokenResolver;
    private final CosmosKeyCredential cosmosKeyCredential;

    CosmosAsyncClient(CosmosClientBuilder builder) {
        this.configs = builder.configs();
        this.serviceEndpoint = builder.getEndpoint();
        this.keyOrResourceToken = builder.getKey();
        this.connectionPolicy = builder.getConnectionPolicy();
        this.desiredConsistencyLevel = builder.getConsistencyLevel();
        this.permissions = builder.getPermissions();
        this.tokenResolver = builder.getTokenResolver();
        this.cosmosKeyCredential = builder.getCosmosKeyCredential();
        this.asyncDocumentClient = new AsyncDocumentClient.Builder().withServiceEndpoint(this.serviceEndpoint).withMasterKeyOrResourceToken(this.keyOrResourceToken).withConnectionPolicy(this.connectionPolicy).withConsistencyLevel(this.desiredConsistencyLevel).withConfigs(this.configs).withTokenResolver(this.tokenResolver).withCosmosKeyCredential(this.cosmosKeyCredential).build();
    }

    AsyncDocumentClient getContextClient() {
        return this.asyncDocumentClient;
    }

    public static CosmosClientBuilder builder() {
        return new CosmosClientBuilder();
    }

    static void setMonitorTelemetry(MeterRegistry registry) {
        RntbdMetrics.add(registry);
    }

    String getServiceEndpoint() {
        return this.serviceEndpoint;
    }

    String getKeyOrResourceToken() {
        return this.keyOrResourceToken;
    }

    ConnectionPolicy getConnectionPolicy() {
        return this.connectionPolicy;
    }

    ConsistencyLevel getDesiredConsistencyLevel() {
        return this.desiredConsistencyLevel;
    }

    List<Permission> getPermissions() {
        return this.permissions;
    }

    AsyncDocumentClient getDocClientWrapper() {
        return this.asyncDocumentClient;
    }

    Configs getConfigs() {
        return this.configs;
    }

    TokenResolver getTokenResolver() {
        return this.tokenResolver;
    }

    CosmosKeyCredential cosmosKeyCredential() {
        return this.cosmosKeyCredential;
    }

    public Mono<CosmosAsyncDatabaseResponse> createDatabaseIfNotExists(CosmosDatabaseProperties databaseSettings) {
        return this.createDatabaseIfNotExistsInternal(this.getDatabase(databaseSettings.getId()));
    }

    public Mono<CosmosAsyncDatabaseResponse> createDatabaseIfNotExists(String id) {
        return this.createDatabaseIfNotExistsInternal(this.getDatabase(id));
    }

    private Mono<CosmosAsyncDatabaseResponse> createDatabaseIfNotExistsInternal(CosmosAsyncDatabase database) {
        return database.read().onErrorResume(exception -> {
            CosmosClientException cosmosClientException;
            Throwable unwrappedException = Exceptions.unwrap((Throwable)exception);
            if (unwrappedException instanceof CosmosClientException && (cosmosClientException = (CosmosClientException)unwrappedException).getStatusCode() == 404) {
                return this.createDatabase(new CosmosDatabaseProperties(database.getId()), new CosmosDatabaseRequestOptions());
            }
            return Mono.error((Throwable)unwrappedException);
        });
    }

    public Mono<CosmosAsyncDatabaseResponse> createDatabase(CosmosDatabaseProperties databaseSettings, CosmosDatabaseRequestOptions options) {
        if (options == null) {
            options = new CosmosDatabaseRequestOptions();
        }
        Database wrappedDatabase = new Database();
        wrappedDatabase.setId(databaseSettings.getId());
        return this.asyncDocumentClient.createDatabase(wrappedDatabase, options.toRequestOptions()).map(databaseResourceResponse -> new CosmosAsyncDatabaseResponse((ResourceResponse<Database>)databaseResourceResponse, this)).single();
    }

    public Mono<CosmosAsyncDatabaseResponse> createDatabase(CosmosDatabaseProperties databaseSettings) {
        return this.createDatabase(databaseSettings, new CosmosDatabaseRequestOptions());
    }

    public Mono<CosmosAsyncDatabaseResponse> createDatabase(String id) {
        return this.createDatabase(new CosmosDatabaseProperties(id), new CosmosDatabaseRequestOptions());
    }

    public Mono<CosmosAsyncDatabaseResponse> createDatabase(CosmosDatabaseProperties databaseSettings, int throughput, CosmosDatabaseRequestOptions options) {
        if (options == null) {
            options = new CosmosDatabaseRequestOptions();
        }
        options.setOfferThroughput(throughput);
        Database wrappedDatabase = new Database();
        wrappedDatabase.setId(databaseSettings.getId());
        return this.asyncDocumentClient.createDatabase(wrappedDatabase, options.toRequestOptions()).map(databaseResourceResponse -> new CosmosAsyncDatabaseResponse((ResourceResponse<Database>)databaseResourceResponse, this)).single();
    }

    public Mono<CosmosAsyncDatabaseResponse> createDatabase(CosmosDatabaseProperties databaseSettings, int throughput) {
        CosmosDatabaseRequestOptions options = new CosmosDatabaseRequestOptions();
        options.setOfferThroughput(throughput);
        return this.createDatabase(databaseSettings, options);
    }

    public Mono<CosmosAsyncDatabaseResponse> createDatabase(String id, int throughput) {
        CosmosDatabaseRequestOptions options = new CosmosDatabaseRequestOptions();
        options.setOfferThroughput(throughput);
        return this.createDatabase(new CosmosDatabaseProperties(id), options);
    }

    public Flux<FeedResponse<CosmosDatabaseProperties>> readAllDatabases(FeedOptions options) {
        return this.getDocClientWrapper().readDatabases(options).map(response -> BridgeInternal.createFeedResponse(CosmosDatabaseProperties.getFromV2Results(response.getResults()), response.getResponseHeaders()));
    }

    public Flux<FeedResponse<CosmosDatabaseProperties>> readAllDatabases() {
        return this.readAllDatabases(new FeedOptions());
    }

    public Flux<FeedResponse<CosmosDatabaseProperties>> queryDatabases(String query, FeedOptions options) {
        return this.queryDatabases(new SqlQuerySpec(query), options);
    }

    public Flux<FeedResponse<CosmosDatabaseProperties>> queryDatabases(SqlQuerySpec querySpec, FeedOptions options) {
        return this.getDocClientWrapper().queryDatabases(querySpec, options).map(response -> BridgeInternal.createFeedResponse(CosmosDatabaseProperties.getFromV2Results(response.getResults()), response.getResponseHeaders()));
    }

    public Mono<DatabaseAccount> readDatabaseAccount() {
        return this.asyncDocumentClient.getDatabaseAccount().single();
    }

    public CosmosAsyncDatabase getDatabase(String id) {
        return new CosmosAsyncDatabase(id, this);
    }

    @Override
    public void close() {
        this.asyncDocumentClient.close();
    }
}

