/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.CosmosAsyncConflictResponse;
import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.CosmosConflictRequestOptions;
import com.azure.cosmos.internal.Conflict;
import com.azure.cosmos.internal.RequestOptions;
import com.azure.cosmos.internal.ResourceResponse;
import reactor.core.publisher.Mono;

public class CosmosAsyncConflict {
    private CosmosAsyncContainer container;
    private String id;

    CosmosAsyncConflict(String id, CosmosAsyncContainer container) {
        this.id = id;
        this.container = container;
    }

    public String getId() {
        return this.id;
    }

    CosmosAsyncConflict setId(String id) {
        this.id = id;
        return this;
    }

    public Mono<CosmosAsyncConflictResponse> read(CosmosConflictRequestOptions options) {
        if (options == null) {
            options = new CosmosConflictRequestOptions();
        }
        RequestOptions requestOptions = options.toRequestOptions();
        return this.container.getDatabase().getDocClientWrapper().readConflict(this.getLink(), requestOptions).map(response -> new CosmosAsyncConflictResponse((ResourceResponse<Conflict>)response, this.container)).single();
    }

    public Mono<CosmosAsyncConflictResponse> delete(CosmosConflictRequestOptions options) {
        if (options == null) {
            options = new CosmosConflictRequestOptions();
        }
        RequestOptions requestOptions = options.toRequestOptions();
        return this.container.getDatabase().getDocClientWrapper().deleteConflict(this.getLink(), requestOptions).map(response -> new CosmosAsyncConflictResponse((ResourceResponse<Conflict>)response, this.container)).single();
    }

    String URIPathSegment() {
        return "conflicts";
    }

    String parentLink() {
        return this.container.getLink();
    }

    String getLink() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.parentLink());
        builder.append("/");
        builder.append(this.URIPathSegment());
        builder.append("/");
        builder.append(this.getId());
        return builder.toString();
    }
}

