/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosAsyncClient;
import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.CosmosAsyncContainerResponse;
import com.azure.cosmos.CosmosAsyncDatabaseResponse;
import com.azure.cosmos.CosmosAsyncUser;
import com.azure.cosmos.CosmosAsyncUserResponse;
import com.azure.cosmos.CosmosClientException;
import com.azure.cosmos.CosmosContainerProperties;
import com.azure.cosmos.CosmosContainerRequestOptions;
import com.azure.cosmos.CosmosDatabaseRequestOptions;
import com.azure.cosmos.CosmosUserProperties;
import com.azure.cosmos.FeedOptions;
import com.azure.cosmos.FeedResponse;
import com.azure.cosmos.Resource;
import com.azure.cosmos.SqlQuerySpec;
import com.azure.cosmos.internal.AsyncDocumentClient;
import com.azure.cosmos.internal.Database;
import com.azure.cosmos.internal.DocumentCollection;
import com.azure.cosmos.internal.Offer;
import com.azure.cosmos.internal.ResourceResponse;
import com.azure.cosmos.internal.User;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CosmosAsyncDatabase {
    private CosmosAsyncClient client;
    private String id;

    CosmosAsyncDatabase(String id, CosmosAsyncClient client) {
        this.id = id;
        this.client = client;
    }

    public String getId() {
        return this.id;
    }

    CosmosAsyncDatabase setId(String id) {
        this.id = id;
        return this;
    }

    public Mono<CosmosAsyncDatabaseResponse> read() {
        return this.read(new CosmosDatabaseRequestOptions());
    }

    public Mono<CosmosAsyncDatabaseResponse> read(CosmosDatabaseRequestOptions options) {
        if (options == null) {
            options = new CosmosDatabaseRequestOptions();
        }
        return this.getDocClientWrapper().readDatabase(this.getLink(), options.toRequestOptions()).map(response -> new CosmosAsyncDatabaseResponse((ResourceResponse<Database>)response, this.getClient())).single();
    }

    public Mono<CosmosAsyncDatabaseResponse> delete() {
        return this.delete(new CosmosDatabaseRequestOptions());
    }

    public Mono<CosmosAsyncDatabaseResponse> delete(CosmosDatabaseRequestOptions options) {
        if (options == null) {
            options = new CosmosDatabaseRequestOptions();
        }
        return this.getDocClientWrapper().deleteDatabase(this.getLink(), options.toRequestOptions()).map(response -> new CosmosAsyncDatabaseResponse((ResourceResponse<Database>)response, this.getClient())).single();
    }

    public Mono<CosmosAsyncContainerResponse> createContainer(CosmosContainerProperties containerSettings) {
        return this.createContainer(containerSettings, new CosmosContainerRequestOptions());
    }

    public Mono<CosmosAsyncContainerResponse> createContainer(CosmosContainerProperties containerProperties, int throughput) {
        if (containerProperties == null) {
            throw new IllegalArgumentException("containerProperties");
        }
        Resource.validateResource(containerProperties);
        CosmosContainerRequestOptions options = new CosmosContainerRequestOptions();
        options.setOfferThroughput(throughput);
        return this.createContainer(containerProperties, options);
    }

    public Mono<CosmosAsyncContainerResponse> createContainer(CosmosContainerProperties containerProperties, CosmosContainerRequestOptions options) {
        if (containerProperties == null) {
            throw new IllegalArgumentException("containerProperties");
        }
        Resource.validateResource(containerProperties);
        if (options == null) {
            options = new CosmosContainerRequestOptions();
        }
        return this.getDocClientWrapper().createCollection(this.getLink(), containerProperties.getV2Collection(), options.toRequestOptions()).map(response -> new CosmosAsyncContainerResponse((ResourceResponse<DocumentCollection>)response, this)).single();
    }

    public Mono<CosmosAsyncContainerResponse> createContainer(CosmosContainerProperties containerProperties, int throughput, CosmosContainerRequestOptions options) {
        if (options == null) {
            options = new CosmosContainerRequestOptions();
        }
        options.setOfferThroughput(throughput);
        return this.createContainer(containerProperties, options);
    }

    public Mono<CosmosAsyncContainerResponse> createContainer(String id, String partitionKeyPath) {
        return this.createContainer(new CosmosContainerProperties(id, partitionKeyPath));
    }

    public Mono<CosmosAsyncContainerResponse> createContainer(String id, String partitionKeyPath, int throughput) {
        CosmosContainerRequestOptions options = new CosmosContainerRequestOptions();
        options.setOfferThroughput(throughput);
        return this.createContainer(new CosmosContainerProperties(id, partitionKeyPath), options);
    }

    public Mono<CosmosAsyncContainerResponse> createContainerIfNotExists(CosmosContainerProperties containerProperties) {
        CosmosAsyncContainer container = this.getContainer(containerProperties.getId());
        return this.createContainerIfNotExistsInternal(containerProperties, container, null);
    }

    public Mono<CosmosAsyncContainerResponse> createContainerIfNotExists(CosmosContainerProperties containerProperties, int throughput) {
        CosmosContainerRequestOptions options = new CosmosContainerRequestOptions();
        options.setOfferThroughput(throughput);
        CosmosAsyncContainer container = this.getContainer(containerProperties.getId());
        return this.createContainerIfNotExistsInternal(containerProperties, container, options);
    }

    public Mono<CosmosAsyncContainerResponse> createContainerIfNotExists(String id, String partitionKeyPath) {
        CosmosAsyncContainer container = this.getContainer(id);
        return this.createContainerIfNotExistsInternal(new CosmosContainerProperties(id, partitionKeyPath), container, null);
    }

    public Mono<CosmosAsyncContainerResponse> createContainerIfNotExists(String id, String partitionKeyPath, int throughput) {
        CosmosContainerRequestOptions options = new CosmosContainerRequestOptions();
        options.setOfferThroughput(throughput);
        CosmosAsyncContainer container = this.getContainer(id);
        return this.createContainerIfNotExistsInternal(new CosmosContainerProperties(id, partitionKeyPath), container, options);
    }

    private Mono<CosmosAsyncContainerResponse> createContainerIfNotExistsInternal(CosmosContainerProperties containerProperties, CosmosAsyncContainer container, CosmosContainerRequestOptions options) {
        return container.read(options).onErrorResume(exception -> {
            CosmosClientException cosmosClientException;
            Throwable unwrappedException = Exceptions.unwrap((Throwable)exception);
            if (unwrappedException instanceof CosmosClientException && (cosmosClientException = (CosmosClientException)unwrappedException).getStatusCode() == 404) {
                return this.createContainer(containerProperties, options);
            }
            return Mono.error((Throwable)unwrappedException);
        });
    }

    public Flux<FeedResponse<CosmosContainerProperties>> readAllContainers(FeedOptions options) {
        return this.getDocClientWrapper().readCollections(this.getLink(), options).map(response -> BridgeInternal.createFeedResponse(CosmosContainerProperties.getFromV2Results(response.getResults()), response.getResponseHeaders()));
    }

    public Flux<FeedResponse<CosmosContainerProperties>> readAllContainers() {
        return this.readAllContainers(new FeedOptions());
    }

    public Flux<FeedResponse<CosmosContainerProperties>> queryContainers(String query) {
        return this.queryContainers(new SqlQuerySpec(query));
    }

    public Flux<FeedResponse<CosmosContainerProperties>> queryContainers(String query, FeedOptions options) {
        return this.queryContainers(new SqlQuerySpec(query), options);
    }

    public Flux<FeedResponse<CosmosContainerProperties>> queryContainers(SqlQuerySpec querySpec) {
        return this.queryContainers(querySpec, null);
    }

    public Flux<FeedResponse<CosmosContainerProperties>> queryContainers(SqlQuerySpec querySpec, FeedOptions options) {
        return this.getDocClientWrapper().queryCollections(this.getLink(), querySpec, options).map(response -> BridgeInternal.createFeedResponse(CosmosContainerProperties.getFromV2Results(response.getResults()), response.getResponseHeaders()));
    }

    public CosmosAsyncContainer getContainer(String id) {
        return new CosmosAsyncContainer(id, this);
    }

    public Mono<CosmosAsyncUserResponse> createUser(CosmosUserProperties settings) {
        return this.getDocClientWrapper().createUser(this.getLink(), settings.getV2User(), null).map(response -> new CosmosAsyncUserResponse((ResourceResponse<User>)response, this)).single();
    }

    public Mono<CosmosAsyncUserResponse> upsertUser(CosmosUserProperties settings) {
        return this.getDocClientWrapper().upsertUser(this.getLink(), settings.getV2User(), null).map(response -> new CosmosAsyncUserResponse((ResourceResponse<User>)response, this)).single();
    }

    public Flux<FeedResponse<CosmosUserProperties>> readAllUsers() {
        return this.readAllUsers(new FeedOptions());
    }

    public Flux<FeedResponse<CosmosUserProperties>> readAllUsers(FeedOptions options) {
        return this.getDocClientWrapper().readUsers(this.getLink(), options).map(response -> BridgeInternal.createFeedResponse(CosmosUserProperties.getFromV2Results(response.getResults()), response.getResponseHeaders()));
    }

    public Flux<FeedResponse<CosmosUserProperties>> queryUsers(String query) {
        return this.queryUsers(query, null);
    }

    public Flux<FeedResponse<CosmosUserProperties>> queryUsers(String query, FeedOptions options) {
        return this.queryUsers(new SqlQuerySpec(query), options);
    }

    public Flux<FeedResponse<CosmosUserProperties>> queryUsers(SqlQuerySpec querySpec) {
        return this.queryUsers(querySpec, null);
    }

    public Flux<FeedResponse<CosmosUserProperties>> queryUsers(SqlQuerySpec querySpec, FeedOptions options) {
        return this.getDocClientWrapper().queryUsers(this.getLink(), querySpec, options).map(response -> BridgeInternal.createFeedResponseWithQueryMetrics(CosmosUserProperties.getFromV2Results(response.getResults()), response.getResponseHeaders(), response.queryMetrics()));
    }

    public CosmosAsyncUser getUser(String id) {
        return new CosmosAsyncUser(id, this);
    }

    public Mono<Integer> readProvisionedThroughput() {
        return this.read().flatMap(cosmosDatabaseResponse -> this.getDocClientWrapper().queryOffers("select * from c where c.offerResourceId = '" + cosmosDatabaseResponse.getProperties().getResourceId() + "'", new FeedOptions()).single().flatMap(offerFeedResponse -> {
            if (offerFeedResponse.getResults().isEmpty()) {
                return Mono.error((Throwable)BridgeInternal.createCosmosClientException(400, "No offers found for the resource"));
            }
            return this.getDocClientWrapper().readOffer(((Offer)offerFeedResponse.getResults().get(0)).getSelfLink()).single();
        }).map(cosmosContainerResponse1 -> ((Offer)cosmosContainerResponse1.getResource()).getThroughput()));
    }

    public Mono<Integer> replaceProvisionedThroughput(int requestUnitsPerSecond) {
        return this.read().flatMap(cosmosDatabaseResponse -> this.getDocClientWrapper().queryOffers("select * from c where c.offerResourceId = '" + cosmosDatabaseResponse.getProperties().getResourceId() + "'", new FeedOptions()).single().flatMap(offerFeedResponse -> {
            if (offerFeedResponse.getResults().isEmpty()) {
                return Mono.error((Throwable)BridgeInternal.createCosmosClientException(400, "No offers found for the resource"));
            }
            Offer offer = (Offer)offerFeedResponse.getResults().get(0);
            offer.setThroughput(requestUnitsPerSecond);
            return this.getDocClientWrapper().replaceOffer(offer).single();
        }).map(offerResourceResponse -> ((Offer)offerResourceResponse.getResource()).getThroughput()));
    }

    CosmosAsyncClient getClient() {
        return this.client;
    }

    AsyncDocumentClient getDocClientWrapper() {
        return this.client.getDocClientWrapper();
    }

    String URIPathSegment() {
        return "dbs";
    }

    String parentLink() {
        return "";
    }

    String getLink() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.parentLink());
        builder.append("/");
        builder.append(this.URIPathSegment());
        builder.append("/");
        builder.append(this.getId());
        return builder.toString();
    }
}

