/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.CosmosAsyncItemResponse;
import com.azure.cosmos.CosmosItemProperties;
import com.azure.cosmos.CosmosItemRequestOptions;
import com.azure.cosmos.internal.Document;
import com.azure.cosmos.internal.RequestOptions;
import com.azure.cosmos.internal.ResourceResponse;
import reactor.core.publisher.Mono;

public class CosmosAsyncItem {
    private Object partitionKey;
    private CosmosAsyncContainer container;
    private String id;

    CosmosAsyncItem(String id, Object partitionKey, CosmosAsyncContainer container) {
        this.id = id;
        this.partitionKey = partitionKey;
        this.container = container;
    }

    public String getId() {
        return this.id;
    }

    CosmosAsyncItem setId(String id) {
        this.id = id;
        return this;
    }

    public Mono<CosmosAsyncItemResponse> read() {
        return this.read(new CosmosItemRequestOptions(this.partitionKey));
    }

    public Mono<CosmosAsyncItemResponse> read(CosmosItemRequestOptions options) {
        if (options == null) {
            options = new CosmosItemRequestOptions();
        }
        RequestOptions requestOptions = options.toRequestOptions();
        return this.container.getDatabase().getDocClientWrapper().readDocument(this.getLink(), requestOptions).map(response -> new CosmosAsyncItemResponse((ResourceResponse<Document>)response, requestOptions.getPartitionKey(), this.container)).single();
    }

    public Mono<CosmosAsyncItemResponse> replace(Object item) {
        return this.replace(item, new CosmosItemRequestOptions(this.partitionKey));
    }

    public Mono<CosmosAsyncItemResponse> replace(Object item, CosmosItemRequestOptions options) {
        Document doc = CosmosItemProperties.fromObject(item);
        if (options == null) {
            options = new CosmosItemRequestOptions();
        }
        RequestOptions requestOptions = options.toRequestOptions();
        return this.container.getDatabase().getDocClientWrapper().replaceDocument(this.getLink(), doc, requestOptions).map(response -> new CosmosAsyncItemResponse((ResourceResponse<Document>)response, requestOptions.getPartitionKey(), this.container)).single();
    }

    public Mono<CosmosAsyncItemResponse> delete() {
        return this.delete(new CosmosItemRequestOptions(this.partitionKey));
    }

    public Mono<CosmosAsyncItemResponse> delete(CosmosItemRequestOptions options) {
        if (options == null) {
            options = new CosmosItemRequestOptions();
        }
        RequestOptions requestOptions = options.toRequestOptions();
        return this.container.getDatabase().getDocClientWrapper().deleteDocument(this.getLink(), requestOptions).map(response -> new CosmosAsyncItemResponse((ResourceResponse<Document>)response, requestOptions.getPartitionKey(), this.container)).single();
    }

    void setContainer(CosmosAsyncContainer container) {
        this.container = container;
    }

    String URIPathSegment() {
        return "docs";
    }

    String parentLink() {
        return this.container.getLink();
    }

    String getLink() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.parentLink());
        builder.append("/");
        builder.append(this.URIPathSegment());
        builder.append("/");
        builder.append(this.getId());
        return builder.toString();
    }
}

