/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.CosmosAsyncItem;
import com.azure.cosmos.CosmosItemProperties;
import com.azure.cosmos.CosmosResponse;
import com.azure.cosmos.PartitionKey;
import com.azure.cosmos.internal.Document;
import com.azure.cosmos.internal.ResourceResponse;

public class CosmosAsyncItemResponse
extends CosmosResponse<CosmosItemProperties> {
    private CosmosAsyncItem itemClient;

    CosmosAsyncItemResponse(ResourceResponse<Document> response, PartitionKey partitionKey, CosmosAsyncContainer container) {
        super(response);
        if (response.getResource() == null) {
            super.setProperties(null);
        } else {
            super.setProperties(new CosmosItemProperties(response.getResource().toJson()));
            this.itemClient = new CosmosAsyncItem(response.getResource().getId(), partitionKey, container);
        }
    }

    @Override
    public CosmosItemProperties getProperties() {
        return (CosmosItemProperties)super.getProperties();
    }

    public CosmosAsyncItem getItem() {
        return this.itemClient;
    }
}

