/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.CosmosAsyncPermissionResponse;
import com.azure.cosmos.CosmosAsyncUser;
import com.azure.cosmos.CosmosPermissionProperties;
import com.azure.cosmos.CosmosPermissionRequestOptions;
import com.azure.cosmos.internal.Permission;
import com.azure.cosmos.internal.RequestOptions;
import com.azure.cosmos.internal.ResourceResponse;
import reactor.core.publisher.Mono;

public class CosmosAsyncPermission {
    private final CosmosAsyncUser cosmosUser;
    private String id;

    CosmosAsyncPermission(String id, CosmosAsyncUser user) {
        this.id = id;
        this.cosmosUser = user;
    }

    public String id() {
        return this.id;
    }

    CosmosAsyncPermission id(String id) {
        this.id = id;
        return this;
    }

    public Mono<CosmosAsyncPermissionResponse> read(RequestOptions options) {
        return this.cosmosUser.getDatabase().getDocClientWrapper().readPermission(this.getLink(), options).map(response -> new CosmosAsyncPermissionResponse((ResourceResponse<Permission>)response, this.cosmosUser)).single();
    }

    public Mono<CosmosAsyncPermissionResponse> replace(CosmosPermissionProperties permissionSettings, RequestOptions options) {
        return this.cosmosUser.getDatabase().getDocClientWrapper().replacePermission(permissionSettings.getV2Permissions(), options).map(response -> new CosmosAsyncPermissionResponse((ResourceResponse<Permission>)response, this.cosmosUser)).single();
    }

    public Mono<CosmosAsyncPermissionResponse> delete(CosmosPermissionRequestOptions options) {
        if (options == null) {
            options = new CosmosPermissionRequestOptions();
        }
        return this.cosmosUser.getDatabase().getDocClientWrapper().deletePermission(this.getLink(), options.toRequestOptions()).map(response -> new CosmosAsyncPermissionResponse((ResourceResponse<Permission>)response, this.cosmosUser)).single();
    }

    String URIPathSegment() {
        return "permissions";
    }

    String parentLink() {
        return this.cosmosUser.getLink();
    }

    String getLink() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.parentLink());
        builder.append("/");
        builder.append(this.URIPathSegment());
        builder.append("/");
        builder.append(this.id());
        return builder.toString();
    }
}

