/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.CosmosAsyncClient;
import com.azure.cosmos.CosmosAsyncDatabaseResponse;
import com.azure.cosmos.CosmosClientBuilder;
import com.azure.cosmos.CosmosClientException;
import com.azure.cosmos.CosmosDatabase;
import com.azure.cosmos.CosmosDatabaseProperties;
import com.azure.cosmos.CosmosDatabaseRequestOptions;
import com.azure.cosmos.CosmosDatabaseResponse;
import com.azure.cosmos.FeedOptions;
import com.azure.cosmos.FeedResponse;
import com.azure.cosmos.SqlQuerySpec;
import java.util.Iterator;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;

public class CosmosClient
implements AutoCloseable {
    private final CosmosAsyncClient asyncClientWrapper;

    public CosmosClient(CosmosClientBuilder builder) {
        this.asyncClientWrapper = builder.buildAsyncClient();
    }

    public static CosmosClientBuilder builder() {
        return new CosmosClientBuilder();
    }

    public CosmosDatabaseResponse createDatabaseIfNotExists(CosmosDatabaseProperties databaseProperties) throws CosmosClientException {
        return this.mapDatabaseResponseAndBlock(this.asyncClientWrapper.createDatabaseIfNotExists(databaseProperties));
    }

    public CosmosDatabaseResponse createDatabaseIfNotExists(String id) throws CosmosClientException {
        return this.mapDatabaseResponseAndBlock(this.asyncClientWrapper.createDatabaseIfNotExists(id));
    }

    public CosmosDatabaseResponse createDatabase(CosmosDatabaseProperties databaseProperties, CosmosDatabaseRequestOptions options) throws CosmosClientException {
        return this.mapDatabaseResponseAndBlock(this.asyncClientWrapper.createDatabase(databaseProperties, options));
    }

    public CosmosDatabaseResponse createDatabase(CosmosDatabaseProperties databaseProperties) throws CosmosClientException {
        return this.mapDatabaseResponseAndBlock(this.asyncClientWrapper.createDatabase(databaseProperties));
    }

    public CosmosDatabaseResponse createDatabase(String id) throws CosmosClientException {
        return this.mapDatabaseResponseAndBlock(this.asyncClientWrapper.createDatabase(id));
    }

    public CosmosDatabaseResponse createDatabase(CosmosDatabaseProperties databaseProperties, int throughput, CosmosDatabaseRequestOptions options) throws CosmosClientException {
        return this.mapDatabaseResponseAndBlock(this.asyncClientWrapper.createDatabase(databaseProperties, throughput, options));
    }

    public CosmosDatabaseResponse createDatabase(CosmosDatabaseProperties databaseProperties, int throughput) throws CosmosClientException {
        return this.mapDatabaseResponseAndBlock(this.asyncClientWrapper.createDatabase(databaseProperties, throughput));
    }

    public CosmosDatabaseResponse createDatabase(String id, int throughput) throws CosmosClientException {
        return this.mapDatabaseResponseAndBlock(this.asyncClientWrapper.createDatabase(id, throughput));
    }

    CosmosDatabaseResponse mapDatabaseResponseAndBlock(Mono<CosmosAsyncDatabaseResponse> databaseMono) throws CosmosClientException {
        try {
            return (CosmosDatabaseResponse)databaseMono.map(this::convertResponse).block();
        }
        catch (Exception ex) {
            Throwable throwable = Exceptions.unwrap((Throwable)ex);
            if (throwable instanceof CosmosClientException) {
                throw (CosmosClientException)throwable;
            }
            throw ex;
        }
    }

    public Iterator<FeedResponse<CosmosDatabaseProperties>> readAllDatabases(FeedOptions options) {
        return this.asyncClientWrapper.readAllDatabases(options).toIterable().iterator();
    }

    public Iterator<FeedResponse<CosmosDatabaseProperties>> readAllDatabases() {
        return this.asyncClientWrapper.readAllDatabases().toIterable().iterator();
    }

    public Iterator<FeedResponse<CosmosDatabaseProperties>> queryDatabases(String query, FeedOptions options) {
        return this.asyncClientWrapper.queryDatabases(query, options).toIterable().iterator();
    }

    public Iterator<FeedResponse<CosmosDatabaseProperties>> queryDatabases(SqlQuerySpec querySpec, FeedOptions options) {
        return this.asyncClientWrapper.queryDatabases(querySpec, options).toIterable().iterator();
    }

    public CosmosDatabase getDatabase(String id) {
        return new CosmosDatabase(id, this, this.asyncClientWrapper.getDatabase(id));
    }

    CosmosDatabaseResponse convertResponse(CosmosAsyncDatabaseResponse response) {
        return new CosmosDatabaseResponse(response, this);
    }

    CosmosAsyncClient asyncClient() {
        return this.asyncClientWrapper;
    }

    @Override
    public void close() {
        this.asyncClientWrapper.close();
    }
}

