/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.ChangeFeedOptions;
import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.CosmosAsyncItemResponse;
import com.azure.cosmos.CosmosClientException;
import com.azure.cosmos.CosmosContainerProperties;
import com.azure.cosmos.CosmosContainerRequestOptions;
import com.azure.cosmos.CosmosContainerResponse;
import com.azure.cosmos.CosmosDatabase;
import com.azure.cosmos.CosmosItem;
import com.azure.cosmos.CosmosItemProperties;
import com.azure.cosmos.CosmosItemRequestOptions;
import com.azure.cosmos.CosmosItemResponse;
import com.azure.cosmos.CosmosScripts;
import com.azure.cosmos.FeedOptions;
import com.azure.cosmos.FeedResponse;
import com.azure.cosmos.SqlQuerySpec;
import java.util.Iterator;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CosmosContainer {
    private final CosmosAsyncContainer containerWrapper;
    private final CosmosDatabase database;
    private final String id;
    private CosmosScripts scripts;

    CosmosContainer(String id, CosmosDatabase database, CosmosAsyncContainer container) {
        this.id = id;
        this.database = database;
        this.containerWrapper = container;
    }

    public String getId() {
        return this.id;
    }

    public CosmosContainerResponse read() throws CosmosClientException {
        return this.database.mapContainerResponseAndBlock(this.containerWrapper.read());
    }

    public CosmosContainerResponse read(CosmosContainerRequestOptions options) throws CosmosClientException {
        return this.database.mapContainerResponseAndBlock(this.containerWrapper.read(options));
    }

    public CosmosContainerResponse delete(CosmosContainerRequestOptions options) throws CosmosClientException {
        return this.database.mapContainerResponseAndBlock(this.containerWrapper.delete(options));
    }

    public CosmosContainerResponse delete() throws CosmosClientException {
        return this.database.mapContainerResponseAndBlock(this.containerWrapper.delete());
    }

    public CosmosContainerResponse replace(CosmosContainerProperties containerProperties) throws CosmosClientException {
        return this.database.mapContainerResponseAndBlock(this.containerWrapper.replace(containerProperties));
    }

    public CosmosContainerResponse replace(CosmosContainerProperties containerProperties, CosmosContainerRequestOptions options) throws CosmosClientException {
        return this.database.mapContainerResponseAndBlock(this.containerWrapper.replace(containerProperties, options));
    }

    public Integer readProvisionedThroughput() throws CosmosClientException {
        return CosmosDatabase.throughputResponseToBlock(this.containerWrapper.readProvisionedThroughput());
    }

    public Integer replaceProvisionedThroughput(int requestUnitsPerSecond) throws CosmosClientException {
        return CosmosDatabase.throughputResponseToBlock(this.containerWrapper.replaceProvisionedThroughput(requestUnitsPerSecond));
    }

    public CosmosItemResponse createItem(Object item) throws CosmosClientException {
        return this.mapItemResponseAndBlock(this.containerWrapper.createItem(item));
    }

    public CosmosItemResponse createItem(Object item, CosmosItemRequestOptions options) throws CosmosClientException {
        return this.mapItemResponseAndBlock(this.containerWrapper.createItem(item, options));
    }

    public CosmosItemResponse upsertItem(Object item) throws CosmosClientException {
        return this.mapItemResponseAndBlock(this.containerWrapper.upsertItem(item));
    }

    public CosmosItemResponse upsertItem(Object item, CosmosItemRequestOptions options) throws CosmosClientException {
        return this.mapItemResponseAndBlock(this.containerWrapper.createItem(item, options));
    }

    CosmosItemResponse mapItemResponseAndBlock(Mono<CosmosAsyncItemResponse> itemMono) throws CosmosClientException {
        try {
            return (CosmosItemResponse)itemMono.map(this::convertResponse).block();
        }
        catch (Exception ex) {
            Throwable throwable = Exceptions.unwrap((Throwable)ex);
            if (throwable instanceof CosmosClientException) {
                throw (CosmosClientException)throwable;
            }
            throw ex;
        }
    }

    public Iterator<FeedResponse<CosmosItemProperties>> readAllItems(FeedOptions options) {
        return this.getFeedIterator(this.containerWrapper.readAllItems(options));
    }

    public Iterator<FeedResponse<CosmosItemProperties>> queryItems(String query, FeedOptions options) {
        return this.getFeedIterator(this.containerWrapper.queryItems(query, options));
    }

    public Iterator<FeedResponse<CosmosItemProperties>> queryItems(SqlQuerySpec querySpec, FeedOptions options) {
        return this.getFeedIterator(this.containerWrapper.queryItems(querySpec, options));
    }

    public Iterator<FeedResponse<CosmosItemProperties>> queryChangeFeedItems(ChangeFeedOptions changeFeedOptions) {
        return this.getFeedIterator(this.containerWrapper.queryChangeFeedItems(changeFeedOptions));
    }

    public CosmosItem getItem(String id, Object partitionKey) {
        return new CosmosItem(id, partitionKey, this, this.containerWrapper.getItem(id, partitionKey));
    }

    public CosmosScripts getScripts() {
        if (this.scripts == null) {
            this.scripts = new CosmosScripts(this, this.containerWrapper.getScripts());
        }
        return this.scripts;
    }

    private CosmosItemResponse convertResponse(CosmosAsyncItemResponse response) {
        return new CosmosItemResponse(response, null, this);
    }

    private Iterator<FeedResponse<CosmosItemProperties>> getFeedIterator(Flux<FeedResponse<CosmosItemProperties>> itemFlux) {
        return itemFlux.toIterable(1).iterator();
    }
}

