/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.CosmosAsyncDatabaseResponse;
import com.azure.cosmos.CosmosClient;
import com.azure.cosmos.CosmosDatabase;
import com.azure.cosmos.CosmosDatabaseProperties;
import com.azure.cosmos.CosmosResponse;

public class CosmosDatabaseResponse
extends CosmosResponse<CosmosDatabaseProperties> {
    private final CosmosAsyncDatabaseResponse responseWrapper;
    private final CosmosDatabase database;

    CosmosDatabaseResponse(CosmosAsyncDatabaseResponse response, CosmosClient client) {
        super(response.resourceResponseWrapper, response.getProperties());
        this.responseWrapper = response;
        this.database = this.responseWrapper.getDatabase() != null ? new CosmosDatabase(this.responseWrapper.getDatabase().getId(), client, this.responseWrapper.getDatabase()) : null;
    }

    public CosmosDatabase getDatabase() {
        return this.database;
    }

    @Override
    public CosmosDatabaseProperties getProperties() {
        return this.responseWrapper.getProperties();
    }

    public long getDatabaseQuota() {
        return this.responseWrapper.getDatabaseQuota();
    }

    public long getDatabaseUsage() {
        return this.responseWrapper.getDatabaseUsage();
    }
}

