/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.Resource;
import com.azure.cosmos.internal.Document;
import com.azure.cosmos.internal.Utils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;

public class CosmosItemProperties
extends Resource {
    private static final ObjectMapper mapper = Utils.getSimpleObjectMapper();

    public CosmosItemProperties() {
    }

    @Override
    public CosmosItemProperties setId(String id) {
        super.setId(id);
        return this;
    }

    public CosmosItemProperties(String jsonString) {
        super(jsonString);
    }

    static Document fromObject(Object cosmosItem) {
        if (!(cosmosItem instanceof CosmosItemProperties)) {
            try {
                return new Document(mapper.writeValueAsString(cosmosItem));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Can't serialize the object into the json string", e);
            }
        }
        Document typedItem = new Document(((CosmosItemProperties)cosmosItem).toJson());
        return typedItem;
    }

    static List<CosmosItemProperties> getFromV2Results(List<Document> results) {
        return results.stream().map(document -> new CosmosItemProperties(document.toJson())).collect(Collectors.toList());
    }

    public <T> T getObject(Class<?> klass) throws IOException {
        return (T)mapper.readValue(this.toJson(), klass);
    }
}

