/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.PartitionKey;
import com.azure.cosmos.PermissionMode;
import com.azure.cosmos.Resource;
import com.azure.cosmos.internal.Permission;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class CosmosPermissionProperties
extends Resource {
    public static List<CosmosPermissionProperties> getFromV2Results(List<Permission> results) {
        return results.stream().map(permission -> new CosmosPermissionProperties(permission.toJson())).collect(Collectors.toList());
    }

    public CosmosPermissionProperties() {
    }

    @Override
    public CosmosPermissionProperties setId(String id) {
        super.setId(id);
        return this;
    }

    CosmosPermissionProperties(String jsonString) {
        super(jsonString);
    }

    public String getResourceLink() {
        return super.getString("resource");
    }

    public CosmosPermissionProperties setResourceLink(String resourceLink) {
        super.set("resource", resourceLink);
        return this;
    }

    public PermissionMode getPermissionMode() {
        String value = super.getString("permissionMode");
        return PermissionMode.valueOf(StringUtils.upperCase((String)value));
    }

    public CosmosPermissionProperties setPermissionMode(PermissionMode permissionMode) {
        this.set("permissionMode", permissionMode.toString().toLowerCase());
        return this;
    }

    public CosmosPermissionProperties setResourcePartitionKey(PartitionKey partitionKey) {
        super.set("resourcePartitionKey", partitionKey.getInternalPartitionKey().toJson());
        return this;
    }

    Permission getV2Permissions() {
        return new Permission(this.toJson());
    }
}

