/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.SerializationFormattingPolicy;
import com.azure.cosmos.internal.Strings;
import com.azure.cosmos.internal.Utils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSerializable {
    private static final Logger logger = LoggerFactory.getLogger(JsonSerializable.class);
    private static final ObjectMapper OBJECT_MAPPER = Utils.getSimpleObjectMapper();
    private ObjectMapper om;
    transient ObjectNode propertyBag = null;

    protected JsonSerializable() {
        this.propertyBag = OBJECT_MAPPER.createObjectNode();
    }

    JsonSerializable(String jsonString, ObjectMapper objectMapper) {
        this.propertyBag = this.fromJson(jsonString);
        this.om = objectMapper;
    }

    protected JsonSerializable(String jsonString) {
        this.propertyBag = this.fromJson(jsonString);
    }

    JsonSerializable(ObjectNode objectNode) {
        this.propertyBag = objectNode;
    }

    private ObjectMapper getMapper() {
        if (this.om != null) {
            return this.om;
        }
        return OBJECT_MAPPER;
    }

    void setMapper(ObjectMapper om) {
        this.om = om;
    }

    private static void checkForValidPOJO(Class<?> c) {
        if (c.isAnonymousClass() || c.isLocalClass()) {
            throw new IllegalArgumentException(String.format("%s can't be an anonymous or local class.", c.getName()));
        }
        if (c.isMemberClass() && !Modifier.isStatic(c.getModifiers())) {
            throw new IllegalArgumentException(String.format("%s must be static if it's a member class.", c.getName()));
        }
    }

    @JsonIgnore
    public Logger getLogger() {
        return logger;
    }

    void populatePropertyBag() {
    }

    public Map<String, Object> getMap() {
        return (Map)this.getMapper().convertValue((Object)this.propertyBag, HashMap.class);
    }

    public boolean has(String propertyName) {
        return this.propertyBag.has(propertyName);
    }

    void remove(String propertyName) {
        this.propertyBag.remove(propertyName);
    }

    <T> void set(String propertyName, T value) {
        if (value == null) {
            this.propertyBag.putNull(propertyName);
        } else if (value instanceof Collection) {
            ArrayNode jsonArray = this.propertyBag.arrayNode();
            this.internalSetCollection(propertyName, (Collection)value, jsonArray);
            this.propertyBag.set(propertyName, (JsonNode)jsonArray);
        } else if (value instanceof JsonNode) {
            this.propertyBag.set(propertyName, (JsonNode)value);
        } else if (value instanceof JsonSerializable) {
            JsonSerializable castedValue = (JsonSerializable)value;
            if (castedValue != null) {
                castedValue.populatePropertyBag();
            }
            this.propertyBag.set(propertyName, (JsonNode)(castedValue != null ? castedValue.propertyBag : null));
        } else {
            this.propertyBag.set(propertyName, this.getMapper().valueToTree(value));
        }
    }

    private <T> void internalSetCollection(String propertyName, Collection<T> collection, ArrayNode targetArray) {
        for (T childValue : collection) {
            if (childValue == null) {
                targetArray.addNull();
                continue;
            }
            if (childValue instanceof Collection) {
                ArrayNode childArray = targetArray.addArray();
                this.internalSetCollection(propertyName, (Collection)childValue, childArray);
                continue;
            }
            if (childValue instanceof JsonNode) {
                targetArray.add((JsonNode)childValue);
                continue;
            }
            if (childValue instanceof JsonSerializable) {
                JsonSerializable castedValue = (JsonSerializable)childValue;
                castedValue.populatePropertyBag();
                targetArray.add((JsonNode)(castedValue.propertyBag != null ? castedValue.propertyBag : this.getMapper().createObjectNode()));
                continue;
            }
            targetArray.add(this.getMapper().valueToTree(childValue));
        }
    }

    public Object get(String propertyName) {
        if (this.has(propertyName) && this.propertyBag.hasNonNull(propertyName)) {
            return JsonSerializable.getValue(this.propertyBag.get(propertyName));
        }
        return null;
    }

    public String getString(String propertyName) {
        if (this.has(propertyName) && this.propertyBag.hasNonNull(propertyName)) {
            return this.propertyBag.get(propertyName).asText();
        }
        return null;
    }

    public Boolean getBoolean(String propertyName) {
        if (this.has(propertyName) && this.propertyBag.hasNonNull(propertyName)) {
            return this.propertyBag.get(propertyName).asBoolean();
        }
        return null;
    }

    public Integer getInt(String propertyName) {
        if (this.has(propertyName) && this.propertyBag.hasNonNull(propertyName)) {
            return this.propertyBag.get(propertyName).asInt();
        }
        return null;
    }

    public Long getLong(String propertyName) {
        if (this.has(propertyName) && this.propertyBag.hasNonNull(propertyName)) {
            return this.propertyBag.get(propertyName).asLong();
        }
        return null;
    }

    public Double getDouble(String propertyName) {
        if (this.has(propertyName) && this.propertyBag.hasNonNull(propertyName)) {
            return new Double(this.propertyBag.get(propertyName).asDouble());
        }
        return null;
    }

    public <T> T getObject(String propertyName, Class<T> c, boolean ... convertFromCamelCase) {
        if (this.propertyBag.has(propertyName) && this.propertyBag.hasNonNull(propertyName)) {
            JsonNode jsonObj = this.propertyBag.get(propertyName);
            if (Number.class.isAssignableFrom(c) || String.class.isAssignableFrom(c) || Boolean.class.isAssignableFrom(c) || Object.class == c) {
                return c.cast(JsonSerializable.getValue(jsonObj));
            }
            if (Enum.class.isAssignableFrom(c)) {
                try {
                    String value = (String)String.class.cast(JsonSerializable.getValue(jsonObj));
                    value = convertFromCamelCase.length > 0 && convertFromCamelCase[0] ? Strings.fromCamelCaseToUpperCase(value) : value;
                    return c.cast(c.getMethod("valueOf", String.class).invoke(null, value));
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    throw new IllegalStateException("Failed to create enum.", e);
                }
            }
            if (JsonSerializable.class.isAssignableFrom(c)) {
                try {
                    Constructor<T> constructor = c.getDeclaredConstructor(String.class);
                    if (Modifier.isPrivate(constructor.getModifiers())) {
                        constructor.setAccessible(true);
                    }
                    return constructor.newInstance(this.toJson(jsonObj));
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    throw new IllegalStateException("Failed to instantiate class object.", e);
                }
            }
            JsonSerializable.checkForValidPOJO(c);
            try {
                return (T)this.getMapper().treeToValue((TreeNode)jsonObj, c);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to get POJO.", e);
            }
        }
        return null;
    }

    public <T> List<T> getList(String propertyName, Class<T> c, boolean ... convertFromCamelCase) {
        if (this.propertyBag.has(propertyName) && this.propertyBag.hasNonNull(propertyName)) {
            ArrayNode jsonArray = (ArrayNode)this.propertyBag.get(propertyName);
            ArrayList<Object> result = new ArrayList<Object>();
            boolean isBaseClass = false;
            boolean isEnumClass = false;
            boolean isJsonSerializable = false;
            if (Number.class.isAssignableFrom(c) || String.class.isAssignableFrom(c) || Boolean.class.isAssignableFrom(c) || Object.class == c) {
                isBaseClass = true;
            } else if (Enum.class.isAssignableFrom(c)) {
                isEnumClass = true;
            } else if (JsonSerializable.class.isAssignableFrom(c)) {
                isJsonSerializable = true;
            } else {
                JsonSerializable.checkForValidPOJO(c);
            }
            for (JsonNode n : jsonArray) {
                if (isBaseClass) {
                    result.add(c.cast(JsonSerializable.getValue(n)));
                    continue;
                }
                if (isEnumClass) {
                    try {
                        String value = (String)String.class.cast(JsonSerializable.getValue(n));
                        value = convertFromCamelCase.length > 0 && convertFromCamelCase[0] ? Strings.fromCamelCaseToUpperCase(value) : value;
                        result.add(c.cast(c.getMethod("valueOf", String.class).invoke(null, value)));
                        continue;
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                        throw new IllegalStateException("Failed to create enum.", e);
                    }
                }
                if (isJsonSerializable) {
                    try {
                        Constructor<T> constructor = c.getDeclaredConstructor(String.class);
                        if (Modifier.isPrivate(constructor.getModifiers())) {
                            constructor.setAccessible(true);
                        }
                        result.add(constructor.newInstance(this.toJson(n)));
                        continue;
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                        throw new IllegalStateException("Failed to instantiate class object.", e);
                    }
                }
                try {
                    result.add(this.getMapper().treeToValue((TreeNode)n, c));
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to get POJO.", e);
                }
            }
            return result;
        }
        return null;
    }

    public <T> Collection<T> getCollection(String propertyName, Class<T> c, boolean ... convertFromCamelCase) {
        return this.getList(propertyName, c, convertFromCamelCase);
    }

    ObjectNode getObject(String propertyName) {
        if (this.propertyBag.has(propertyName) && this.propertyBag.hasNonNull(propertyName)) {
            ObjectNode jsonObj = (ObjectNode)this.propertyBag.get(propertyName);
            return jsonObj;
        }
        return null;
    }

    Collection<ObjectNode> getCollection(String propertyName) {
        ArrayList<ObjectNode> result = null;
        if (this.propertyBag.has(propertyName) && this.propertyBag.hasNonNull(propertyName)) {
            result = new ArrayList<ObjectNode>();
            for (JsonNode n : this.propertyBag.findValues(propertyName)) {
                result.add((ObjectNode)n);
            }
        }
        return result;
    }

    public Object getObjectByPath(List<String> propertyNames) {
        ObjectNode propBag = this.propertyBag;
        JsonNode value = null;
        String propertyName = null;
        Integer matchedProperties = 0;
        Iterator<String> iterator = propertyNames.iterator();
        if (iterator.hasNext()) {
            while (propBag.has(propertyName = iterator.next())) {
                Integer n = matchedProperties;
                Integer n2 = matchedProperties = Integer.valueOf(matchedProperties + 1);
                value = propBag.get(propertyName);
                if (!value.isObject()) break;
                propBag = (ObjectNode)value;
                if (iterator.hasNext()) continue;
            }
            if (value != null && matchedProperties.intValue() == propertyNames.size()) {
                return JsonSerializable.getValue(value);
            }
        }
        return null;
    }

    static Object getValue(JsonNode value) {
        if (value.isValueNode()) {
            switch (value.getNodeType()) {
                case BOOLEAN: {
                    return value.asBoolean();
                }
                case NUMBER: {
                    if (value.isInt()) {
                        return value.asInt();
                    }
                    if (value.isLong()) {
                        return value.asLong();
                    }
                    if (value.isDouble()) {
                        return value.asDouble();
                    }
                }
                case STRING: {
                    return value.asText();
                }
            }
        }
        return value;
    }

    private ObjectNode fromJson(String json) {
        try {
            return (ObjectNode)this.getMapper().readTree(json);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Unable to parse JSON %s", json), e);
        }
    }

    private String toJson(Object object) {
        try {
            return this.getMapper().writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Unable to convert JSON to STRING", e);
        }
    }

    private String toPrettyJson(Object object) {
        try {
            return this.getMapper().writerWithDefaultPrettyPrinter().writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Unable to convert JSON to STRING", e);
        }
    }

    public <T> T toObject(Class<T> c) {
        if (JsonSerializable.class.isAssignableFrom(c) || String.class.isAssignableFrom(c) || Number.class.isAssignableFrom(c) || Boolean.class.isAssignableFrom(c)) {
            throw new IllegalArgumentException("c can only be a POJO class or JSONObject");
        }
        if (ObjectNode.class.isAssignableFrom(c)) {
            if (ObjectNode.class != c) {
                throw new IllegalArgumentException("We support JSONObject but not its sub-classes.");
            }
            return c.cast(this.propertyBag);
        }
        JsonSerializable.checkForValidPOJO(c);
        try {
            return (T)this.getMapper().readValue(this.toJson(), c);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to get POJO.", e);
        }
    }

    public String toJson() {
        return this.toJson(SerializationFormattingPolicy.NONE);
    }

    public String toJson(SerializationFormattingPolicy formattingPolicy) {
        this.populatePropertyBag();
        if (SerializationFormattingPolicy.INDENTED.equals((Object)formattingPolicy)) {
            return this.toPrettyJson(this.propertyBag);
        }
        return this.toJson(this.propertyBag);
    }

    public String toString() {
        return this.toJson(this.propertyBag);
    }
}

