/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.internal;

import com.azure.cosmos.ChangeFeedOptions;
import com.azure.cosmos.ConnectionPolicy;
import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.CosmosKeyCredential;
import com.azure.cosmos.DatabaseAccount;
import com.azure.cosmos.FeedOptions;
import com.azure.cosmos.FeedResponse;
import com.azure.cosmos.SqlQuerySpec;
import com.azure.cosmos.TokenResolver;
import com.azure.cosmos.internal.Configs;
import com.azure.cosmos.internal.Conflict;
import com.azure.cosmos.internal.Database;
import com.azure.cosmos.internal.Document;
import com.azure.cosmos.internal.DocumentCollection;
import com.azure.cosmos.internal.Offer;
import com.azure.cosmos.internal.PartitionKeyRange;
import com.azure.cosmos.internal.Permission;
import com.azure.cosmos.internal.RequestOptions;
import com.azure.cosmos.internal.ResourceResponse;
import com.azure.cosmos.internal.RxDocumentClientImpl;
import com.azure.cosmos.internal.StoredProcedure;
import com.azure.cosmos.internal.StoredProcedureResponse;
import com.azure.cosmos.internal.Trigger;
import com.azure.cosmos.internal.User;
import com.azure.cosmos.internal.UserDefinedFunction;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import reactor.core.publisher.Flux;

public interface AsyncDocumentClient {
    public URI getServiceEndpoint();

    public URI getWriteEndpoint();

    public URI getReadEndpoint();

    public ConnectionPolicy getConnectionPolicy();

    public Flux<ResourceResponse<Database>> createDatabase(Database var1, RequestOptions var2);

    public Flux<ResourceResponse<Database>> deleteDatabase(String var1, RequestOptions var2);

    public Flux<ResourceResponse<Database>> readDatabase(String var1, RequestOptions var2);

    public Flux<FeedResponse<Database>> readDatabases(FeedOptions var1);

    public Flux<FeedResponse<Database>> queryDatabases(String var1, FeedOptions var2);

    public Flux<FeedResponse<Database>> queryDatabases(SqlQuerySpec var1, FeedOptions var2);

    public Flux<ResourceResponse<DocumentCollection>> createCollection(String var1, DocumentCollection var2, RequestOptions var3);

    public Flux<ResourceResponse<DocumentCollection>> replaceCollection(DocumentCollection var1, RequestOptions var2);

    public Flux<ResourceResponse<DocumentCollection>> deleteCollection(String var1, RequestOptions var2);

    public Flux<ResourceResponse<DocumentCollection>> readCollection(String var1, RequestOptions var2);

    public Flux<FeedResponse<DocumentCollection>> readCollections(String var1, FeedOptions var2);

    public Flux<FeedResponse<DocumentCollection>> queryCollections(String var1, String var2, FeedOptions var3);

    public Flux<FeedResponse<DocumentCollection>> queryCollections(String var1, SqlQuerySpec var2, FeedOptions var3);

    public Flux<ResourceResponse<Document>> createDocument(String var1, Object var2, RequestOptions var3, boolean var4);

    public Flux<ResourceResponse<Document>> upsertDocument(String var1, Object var2, RequestOptions var3, boolean var4);

    public Flux<ResourceResponse<Document>> replaceDocument(String var1, Object var2, RequestOptions var3);

    public Flux<ResourceResponse<Document>> replaceDocument(Document var1, RequestOptions var2);

    public Flux<ResourceResponse<Document>> deleteDocument(String var1, RequestOptions var2);

    public Flux<ResourceResponse<Document>> readDocument(String var1, RequestOptions var2);

    public Flux<FeedResponse<Document>> readDocuments(String var1, FeedOptions var2);

    public Flux<FeedResponse<Document>> queryDocuments(String var1, String var2, FeedOptions var3);

    public Flux<FeedResponse<Document>> queryDocuments(String var1, SqlQuerySpec var2, FeedOptions var3);

    public Flux<FeedResponse<Document>> queryDocumentChangeFeed(String var1, ChangeFeedOptions var2);

    public Flux<FeedResponse<PartitionKeyRange>> readPartitionKeyRanges(String var1, FeedOptions var2);

    public Flux<ResourceResponse<StoredProcedure>> createStoredProcedure(String var1, StoredProcedure var2, RequestOptions var3);

    public Flux<ResourceResponse<StoredProcedure>> upsertStoredProcedure(String var1, StoredProcedure var2, RequestOptions var3);

    public Flux<ResourceResponse<StoredProcedure>> replaceStoredProcedure(StoredProcedure var1, RequestOptions var2);

    public Flux<ResourceResponse<StoredProcedure>> deleteStoredProcedure(String var1, RequestOptions var2);

    public Flux<ResourceResponse<StoredProcedure>> readStoredProcedure(String var1, RequestOptions var2);

    public Flux<FeedResponse<StoredProcedure>> readStoredProcedures(String var1, FeedOptions var2);

    public Flux<FeedResponse<StoredProcedure>> queryStoredProcedures(String var1, String var2, FeedOptions var3);

    public Flux<FeedResponse<StoredProcedure>> queryStoredProcedures(String var1, SqlQuerySpec var2, FeedOptions var3);

    public Flux<StoredProcedureResponse> executeStoredProcedure(String var1, Object[] var2);

    public Flux<StoredProcedureResponse> executeStoredProcedure(String var1, RequestOptions var2, Object[] var3);

    public Flux<ResourceResponse<Trigger>> createTrigger(String var1, Trigger var2, RequestOptions var3);

    public Flux<ResourceResponse<Trigger>> upsertTrigger(String var1, Trigger var2, RequestOptions var3);

    public Flux<ResourceResponse<Trigger>> replaceTrigger(Trigger var1, RequestOptions var2);

    public Flux<ResourceResponse<Trigger>> deleteTrigger(String var1, RequestOptions var2);

    public Flux<ResourceResponse<Trigger>> readTrigger(String var1, RequestOptions var2);

    public Flux<FeedResponse<Trigger>> readTriggers(String var1, FeedOptions var2);

    public Flux<FeedResponse<Trigger>> queryTriggers(String var1, String var2, FeedOptions var3);

    public Flux<FeedResponse<Trigger>> queryTriggers(String var1, SqlQuerySpec var2, FeedOptions var3);

    public Flux<ResourceResponse<UserDefinedFunction>> createUserDefinedFunction(String var1, UserDefinedFunction var2, RequestOptions var3);

    public Flux<ResourceResponse<UserDefinedFunction>> upsertUserDefinedFunction(String var1, UserDefinedFunction var2, RequestOptions var3);

    public Flux<ResourceResponse<UserDefinedFunction>> replaceUserDefinedFunction(UserDefinedFunction var1, RequestOptions var2);

    public Flux<ResourceResponse<UserDefinedFunction>> deleteUserDefinedFunction(String var1, RequestOptions var2);

    public Flux<ResourceResponse<UserDefinedFunction>> readUserDefinedFunction(String var1, RequestOptions var2);

    public Flux<FeedResponse<UserDefinedFunction>> readUserDefinedFunctions(String var1, FeedOptions var2);

    public Flux<FeedResponse<UserDefinedFunction>> queryUserDefinedFunctions(String var1, String var2, FeedOptions var3);

    public Flux<FeedResponse<UserDefinedFunction>> queryUserDefinedFunctions(String var1, SqlQuerySpec var2, FeedOptions var3);

    public Flux<ResourceResponse<Conflict>> readConflict(String var1, RequestOptions var2);

    public Flux<FeedResponse<Conflict>> readConflicts(String var1, FeedOptions var2);

    public Flux<FeedResponse<Conflict>> queryConflicts(String var1, String var2, FeedOptions var3);

    public Flux<FeedResponse<Conflict>> queryConflicts(String var1, SqlQuerySpec var2, FeedOptions var3);

    public Flux<ResourceResponse<Conflict>> deleteConflict(String var1, RequestOptions var2);

    public Flux<ResourceResponse<User>> createUser(String var1, User var2, RequestOptions var3);

    public Flux<ResourceResponse<User>> upsertUser(String var1, User var2, RequestOptions var3);

    public Flux<ResourceResponse<User>> replaceUser(User var1, RequestOptions var2);

    public Flux<ResourceResponse<User>> deleteUser(String var1, RequestOptions var2);

    public Flux<ResourceResponse<User>> readUser(String var1, RequestOptions var2);

    public Flux<FeedResponse<User>> readUsers(String var1, FeedOptions var2);

    public Flux<FeedResponse<User>> queryUsers(String var1, String var2, FeedOptions var3);

    public Flux<FeedResponse<User>> queryUsers(String var1, SqlQuerySpec var2, FeedOptions var3);

    public Flux<ResourceResponse<Permission>> createPermission(String var1, Permission var2, RequestOptions var3);

    public Flux<ResourceResponse<Permission>> upsertPermission(String var1, Permission var2, RequestOptions var3);

    public Flux<ResourceResponse<Permission>> replacePermission(Permission var1, RequestOptions var2);

    public Flux<ResourceResponse<Permission>> deletePermission(String var1, RequestOptions var2);

    public Flux<ResourceResponse<Permission>> readPermission(String var1, RequestOptions var2);

    public Flux<FeedResponse<Permission>> readPermissions(String var1, FeedOptions var2);

    public Flux<FeedResponse<Permission>> queryPermissions(String var1, String var2, FeedOptions var3);

    public Flux<FeedResponse<Permission>> queryPermissions(String var1, SqlQuerySpec var2, FeedOptions var3);

    public Flux<ResourceResponse<Offer>> replaceOffer(Offer var1);

    public Flux<ResourceResponse<Offer>> readOffer(String var1);

    public Flux<FeedResponse<Offer>> readOffers(FeedOptions var1);

    public Flux<FeedResponse<Offer>> queryOffers(String var1, FeedOptions var2);

    public Flux<FeedResponse<Offer>> queryOffers(SqlQuerySpec var1, FeedOptions var2);

    public Flux<DatabaseAccount> getDatabaseAccount();

    public void close();

    public static class Builder {
        Configs configs = new Configs();
        ConnectionPolicy connectionPolicy;
        ConsistencyLevel desiredConsistencyLevel;
        List<Permission> permissionFeed;
        String masterKeyOrResourceToken;
        URI serviceEndpoint;
        TokenResolver tokenResolver;
        CosmosKeyCredential cosmosKeyCredential;

        public Builder withServiceEndpoint(String serviceEndpoint) {
            try {
                this.serviceEndpoint = new URI(serviceEndpoint);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
            return this;
        }

        @Deprecated
        public Builder withMasterKey(String masterKeyOrResourceToken) {
            this.masterKeyOrResourceToken = masterKeyOrResourceToken;
            return this;
        }

        public Builder withMasterKeyOrResourceToken(String masterKeyOrResourceToken) {
            this.masterKeyOrResourceToken = masterKeyOrResourceToken;
            return this;
        }

        public Builder withPermissionFeed(List<Permission> permissionFeed) {
            this.permissionFeed = permissionFeed;
            return this;
        }

        public Builder withConsistencyLevel(ConsistencyLevel desiredConsistencyLevel) {
            this.desiredConsistencyLevel = desiredConsistencyLevel;
            return this;
        }

        public Builder withConfigs(Configs configs) {
            this.configs = configs;
            return this;
        }

        public Builder withConnectionPolicy(ConnectionPolicy connectionPolicy) {
            this.connectionPolicy = connectionPolicy;
            return this;
        }

        public Builder withCosmosKeyCredential(CosmosKeyCredential cosmosKeyCredential) {
            if (cosmosKeyCredential != null && StringUtils.isEmpty((CharSequence)cosmosKeyCredential.getKey())) {
                throw new IllegalArgumentException("Cannot buildAsyncClient client with empty key credential");
            }
            this.cosmosKeyCredential = cosmosKeyCredential;
            return this;
        }

        public Builder withTokenResolver(TokenResolver tokenResolver) {
            this.tokenResolver = tokenResolver;
            return this;
        }

        private void ifThrowIllegalArgException(boolean value, String error) {
            if (value) {
                throw new IllegalArgumentException(error);
            }
        }

        public AsyncDocumentClient build() {
            this.ifThrowIllegalArgException(this.serviceEndpoint == null, "cannot buildAsyncClient client without service endpoint");
            this.ifThrowIllegalArgException(this.masterKeyOrResourceToken == null && (this.permissionFeed == null || this.permissionFeed.isEmpty()) && this.tokenResolver == null && this.cosmosKeyCredential == null, "cannot buildAsyncClient client without any one of masterKey, resource token, permissionFeed, tokenResolver and cosmos key credential");
            this.ifThrowIllegalArgException(this.cosmosKeyCredential != null && StringUtils.isEmpty((CharSequence)this.cosmosKeyCredential.getKey()), "cannot buildAsyncClient client without key credential");
            RxDocumentClientImpl client = new RxDocumentClientImpl(this.serviceEndpoint, this.masterKeyOrResourceToken, this.permissionFeed, this.connectionPolicy, this.desiredConsistencyLevel, this.configs, this.tokenResolver, this.cosmosKeyCredential);
            client.init();
            return client;
        }

        public Configs getConfigs() {
            return this.configs;
        }

        public void setConfigs(Configs configs) {
            this.configs = configs;
        }

        public ConnectionPolicy getConnectionPolicy() {
            return this.connectionPolicy;
        }

        public void setConnectionPolicy(ConnectionPolicy connectionPolicy) {
            this.connectionPolicy = connectionPolicy;
        }

        public ConsistencyLevel getDesiredConsistencyLevel() {
            return this.desiredConsistencyLevel;
        }

        public void setDesiredConsistencyLevel(ConsistencyLevel desiredConsistencyLevel) {
            this.desiredConsistencyLevel = desiredConsistencyLevel;
        }

        public List<Permission> getPermissionFeed() {
            return this.permissionFeed;
        }

        public void setPermissionFeed(List<Permission> permissionFeed) {
            this.permissionFeed = permissionFeed;
        }

        public String getMasterKeyOrResourceToken() {
            return this.masterKeyOrResourceToken;
        }

        public void setMasterKeyOrResourceToken(String masterKeyOrResourceToken) {
            this.masterKeyOrResourceToken = masterKeyOrResourceToken;
        }

        public URI getServiceEndpoint() {
            return this.serviceEndpoint;
        }

        public void setServiceEndpoint(URI serviceEndpoint) {
            this.serviceEndpoint = serviceEndpoint;
        }

        public TokenResolver getTokenResolver() {
            return this.tokenResolver;
        }

        public void setTokenResolver(TokenResolver tokenResolver) {
            this.tokenResolver = tokenResolver;
        }

        public CosmosKeyCredential getCosmosKeyCredential() {
            return this.cosmosKeyCredential;
        }
    }
}

