/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.internal;

import com.azure.cosmos.internal.IRetryPolicy;
import com.azure.cosmos.internal.Quadruple;
import com.azure.cosmos.internal.RetryUtils;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.function.Function;
import reactor.core.publisher.Mono;

public class BackoffRetryUtility {
    public static final Quadruple<Boolean, Boolean, Duration, Integer> InitialArgumentValuePolicyArg = Quadruple.with(false, false, Duration.ofSeconds(60L), 0);

    public static <T> Mono<T> executeRetry(Callable<Mono<T>> callbackMethod, IRetryPolicy retryPolicy) {
        return Mono.defer(() -> {
            try {
                return (Mono)callbackMethod.call();
            }
            catch (Exception e) {
                return Mono.error((Throwable)e);
            }
        }).retryWhen(RetryUtils.toRetryWhenFunc(retryPolicy));
    }

    public static <T> Mono<T> executeAsync(Function<Quadruple<Boolean, Boolean, Duration, Integer>, Mono<T>> callbackMethod, IRetryPolicy retryPolicy, Function<Quadruple<Boolean, Boolean, Duration, Integer>, Mono<T>> inBackoffAlternateCallbackMethod, Duration minBackoffForInBackoffCallback) {
        return Mono.defer(() -> ((Mono)callbackMethod.apply(InitialArgumentValuePolicyArg)).onErrorResume(RetryUtils.toRetryWithAlternateFunc(callbackMethod, retryPolicy, inBackoffAlternateCallbackMethod, minBackoffForInBackoffCallback)));
    }
}

