/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.internal;

import com.azure.cosmos.CosmosClientException;
import com.azure.cosmos.internal.Exceptions;
import com.azure.cosmos.internal.IDocumentClientRetryPolicy;
import com.azure.cosmos.internal.IRetryPolicy;
import com.azure.cosmos.internal.ISessionContainer;
import com.azure.cosmos.internal.RxDocumentServiceRequest;
import com.azure.cosmos.internal.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class ClearingSessionContainerClientRetryPolicy
implements IDocumentClientRetryPolicy {
    private static final Logger logger = LoggerFactory.getLogger(ClearingSessionContainerClientRetryPolicy.class);
    private final IDocumentClientRetryPolicy retryPolicy;
    private final ISessionContainer sessionContainer;
    private RxDocumentServiceRequest request;
    private boolean hasTriggered = false;

    public ClearingSessionContainerClientRetryPolicy(ISessionContainer sessionContainer, IDocumentClientRetryPolicy retryPolicy) {
        this.sessionContainer = sessionContainer;
        this.retryPolicy = retryPolicy;
    }

    @Override
    public void onBeforeSendRequest(RxDocumentServiceRequest request) {
        this.request = request;
        this.retryPolicy.onBeforeSendRequest(request);
    }

    @Override
    public Mono<IRetryPolicy.ShouldRetryResult> shouldRetry(Exception e) {
        return this.retryPolicy.shouldRetry(e).flatMap(shouldRetryResult -> {
            if (!shouldRetryResult.shouldRetry && !this.hasTriggered) {
                CosmosClientException clientException = Utils.as(e, CosmosClientException.class);
                if (this.request == null) {
                    logger.error("onBeforeSendRequest is not invoked, encountered failure due to request being null", (Throwable)e);
                    return Mono.just((Object)IRetryPolicy.ShouldRetryResult.error(e));
                }
                if (clientException != null && this.request.getIsNameBased() && Exceptions.isStatusCode(clientException, 404) && Exceptions.isSubStatusCode(clientException, 1002)) {
                    logger.warn("Clear the token for named base request {}", (Object)this.request.getResourceAddress());
                    this.sessionContainer.clearTokenByCollectionFullName(this.request.getResourceAddress());
                    this.hasTriggered = true;
                }
            }
            return Mono.just((Object)shouldRetryResult);
        });
    }
}

