/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.internal;

import java.util.ArrayList;
import java.util.List;

public final class PathParser {
    private static final char segmentSeparator = '/';

    public static List<String> getPathParts(String path) {
        ArrayList<String> tokens = new ArrayList<String>();
        int currentIndex = 0;
        while (currentIndex < path.length()) {
            if (path.charAt(currentIndex) != '/') {
                throw new IllegalArgumentException(String.format("INVALID path, failed at index %d.", currentIndex));
            }
            if (++currentIndex == path.length()) break;
            if (path.charAt(currentIndex) == '\"' || path.charAt(currentIndex) == '\'') {
                char quote = path.charAt(currentIndex);
                int newIndex = ++currentIndex;
                while (true) {
                    if ((newIndex = path.indexOf(quote, newIndex)) == -1) {
                        throw new IllegalArgumentException(String.format("INVALID path, failed at index %d.", currentIndex));
                    }
                    if (path.charAt(newIndex - 1) != '\\') break;
                    ++newIndex;
                }
                String token = path.substring(currentIndex, newIndex);
                tokens.add(token);
                currentIndex = newIndex + 1;
                continue;
            }
            int newIndex = path.indexOf(47, currentIndex);
            String token = null;
            if (newIndex == -1) {
                token = path.substring(currentIndex);
                currentIndex = path.length();
            } else {
                token = path.substring(currentIndex, newIndex);
                currentIndex = newIndex;
            }
            token = token.trim();
            tokens.add(token);
        }
        return tokens;
    }
}

