/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.internal.caches;

import com.azure.cosmos.InvalidPartitionException;
import com.azure.cosmos.NotFoundException;
import com.azure.cosmos.internal.DocumentCollection;
import com.azure.cosmos.internal.PathsHelper;
import com.azure.cosmos.internal.ResourceId;
import com.azure.cosmos.internal.RxDocumentServiceRequest;
import com.azure.cosmos.internal.caches.AsyncCache;
import com.azure.cosmos.internal.caches.IEqualityComparer;
import com.azure.cosmos.internal.routing.PartitionKeyRangeIdentity;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;

public abstract class RxCollectionCache {
    private final AsyncCache<String, DocumentCollection> collectionInfoByNameCache = new AsyncCache(new CollectionRidComparer());
    private final AsyncCache<String, DocumentCollection> collectionInfoByIdCache = new AsyncCache(new CollectionRidComparer());

    protected RxCollectionCache() {
    }

    public Mono<DocumentCollection> resolveCollectionAsync(RxDocumentServiceRequest request) {
        Mono init = null;
        if (request.getIsNameBased()) {
            if (request.isForceNameCacheRefresh()) {
                Mono<Void> mono = this.refreshAsync(request);
                init = mono.then(Mono.fromRunnable(() -> request.setForceNameCacheRefresh(false)));
            }
            Mono collectionInfoObs = this.resolveByPartitionKeyRangeIdentityAsync(request.getPartitionKeyRangeIdentity(), request.properties);
            if (init != null) {
                collectionInfoObs = init.then(collectionInfoObs);
            }
            return collectionInfoObs.flatMap(Mono::just).switchIfEmpty(Mono.defer(() -> {
                if (request.requestContext.resolvedCollectionRid == null) {
                    Mono<DocumentCollection> collectionInfoRes = this.resolveByNameAsync(request.getResourceAddress(), request.properties);
                    return collectionInfoRes.flatMap(collection -> {
                        request.setResourceId(collection.getResourceId());
                        request.requestContext.resolvedCollectionRid = collection.getResourceId();
                        return Mono.just((Object)collection);
                    });
                }
                return this.resolveByRidAsync(request.requestContext.resolvedCollectionRid, request.properties);
            }));
        }
        return this.resolveByPartitionKeyRangeIdentityAsync(request.getPartitionKeyRangeIdentity(), request.properties).flatMap(Mono::just).switchIfEmpty(this.resolveByRidAsync(request.getResourceAddress(), request.properties));
    }

    public void refresh(String resourceAddress, Map<String, Object> properties) {
        if (PathsHelper.isNameBased(resourceAddress)) {
            String resourceFullName = PathsHelper.getCollectionPath(resourceAddress);
            this.collectionInfoByNameCache.refresh(resourceFullName, () -> {
                Mono<DocumentCollection> collectionObs = this.getByNameAsync(resourceFullName, properties);
                return collectionObs.doOnSuccess(collection -> this.collectionInfoByIdCache.set(collection.getResourceId(), (DocumentCollection)collection));
            });
        }
    }

    protected abstract Mono<DocumentCollection> getByRidAsync(String var1, Map<String, Object> var2);

    protected abstract Mono<DocumentCollection> getByNameAsync(String var1, Map<String, Object> var2);

    private Mono<DocumentCollection> resolveByPartitionKeyRangeIdentityAsync(PartitionKeyRangeIdentity partitionKeyRangeIdentity, Map<String, Object> properties) {
        if (partitionKeyRangeIdentity != null && partitionKeyRangeIdentity.getCollectionRid() != null) {
            return this.resolveByRidAsync(partitionKeyRangeIdentity.getCollectionRid(), properties).onErrorResume(e -> {
                Throwable unwrappedException = Exceptions.unwrap((Throwable)e);
                if (unwrappedException instanceof NotFoundException) {
                    return Mono.error((Throwable)new InvalidPartitionException("The specified document collection is invalid."));
                }
                return Mono.error((Throwable)unwrappedException);
            });
        }
        return Mono.empty();
    }

    private Mono<DocumentCollection> resolveByRidAsync(String resourceId, Map<String, Object> properties) {
        ResourceId resourceIdParsed = ResourceId.parse(resourceId);
        String collectionResourceId = resourceIdParsed.getDocumentCollectionId().toString();
        return this.collectionInfoByIdCache.getAsync(collectionResourceId, null, () -> this.getByRidAsync(collectionResourceId, properties));
    }

    private Mono<DocumentCollection> resolveByNameAsync(String resourceAddress, Map<String, Object> properties) {
        String resourceFullName = PathsHelper.getCollectionPath(resourceAddress);
        return this.collectionInfoByNameCache.getAsync(resourceFullName, null, () -> {
            Mono<DocumentCollection> collectionObs = this.getByNameAsync(resourceFullName, properties);
            return collectionObs.doOnSuccess(collection -> this.collectionInfoByIdCache.set(collection.getResourceId(), (DocumentCollection)collection));
        });
    }

    private Mono<Void> refreshAsync(RxDocumentServiceRequest request) {
        Mono mono;
        String resourceFullName = PathsHelper.getCollectionPath(request.getResourceAddress());
        if (request.requestContext.resolvedCollectionRid != null) {
            DocumentCollection obsoleteValue = new DocumentCollection();
            obsoleteValue.setResourceId(request.requestContext.resolvedCollectionRid);
            mono = this.collectionInfoByNameCache.getAsync(resourceFullName, obsoleteValue, () -> {
                Mono<DocumentCollection> collectionObs = this.getByNameAsync(resourceFullName, request.properties);
                return collectionObs.doOnSuccess(collection -> this.collectionInfoByIdCache.set(collection.getResourceId(), (DocumentCollection)collection));
            }).then();
        } else {
            mono = Mono.fromRunnable(() -> this.refresh(request.getResourceAddress(), request.properties));
        }
        return mono.doOnSuccess(aVoid -> {
            request.requestContext.resolvedCollectionRid = null;
        });
    }

    private class CollectionRidComparer
    implements IEqualityComparer<DocumentCollection> {
        private CollectionRidComparer() {
        }

        @Override
        public boolean areEqual(DocumentCollection left, DocumentCollection right) {
            if (left == null && right == null) {
                return true;
            }
            if (left == null ^ right == null) {
                return false;
            }
            return StringUtils.equals((CharSequence)left.getResourceId(), (CharSequence)right.getResourceId());
        }
    }
}

