/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.internal.caches;

import com.azure.cosmos.CosmosClientException;
import com.azure.cosmos.FeedOptions;
import com.azure.cosmos.NotFoundException;
import com.azure.cosmos.internal.AsyncDocumentClient;
import com.azure.cosmos.internal.DocumentCollection;
import com.azure.cosmos.internal.Exceptions;
import com.azure.cosmos.internal.OperationType;
import com.azure.cosmos.internal.PartitionKeyRange;
import com.azure.cosmos.internal.ResourceType;
import com.azure.cosmos.internal.RxDocumentServiceRequest;
import com.azure.cosmos.internal.Utils;
import com.azure.cosmos.internal.caches.AsyncCache;
import com.azure.cosmos.internal.caches.IPartitionKeyRangeCache;
import com.azure.cosmos.internal.caches.RxCollectionCache;
import com.azure.cosmos.internal.routing.CollectionRoutingMap;
import com.azure.cosmos.internal.routing.IServerIdentity;
import com.azure.cosmos.internal.routing.InMemoryCollectionRoutingMap;
import com.azure.cosmos.internal.routing.Range;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RxPartitionKeyRangeCache
implements IPartitionKeyRangeCache {
    private final Logger logger = LoggerFactory.getLogger(RxPartitionKeyRangeCache.class);
    private final AsyncCache<String, CollectionRoutingMap> routingMapCache = new AsyncCache();
    private final AsyncDocumentClient client;
    private final RxCollectionCache collectionCache;

    public RxPartitionKeyRangeCache(AsyncDocumentClient client, RxCollectionCache collectionCache) {
        this.client = client;
        this.collectionCache = collectionCache;
    }

    @Override
    public Mono<CollectionRoutingMap> tryLookupAsync(String collectionRid, CollectionRoutingMap previousValue, Map<String, Object> properties) {
        return this.routingMapCache.getAsync(collectionRid, previousValue, () -> this.getRoutingMapForCollectionAsync(collectionRid, previousValue, properties)).onErrorResume(err -> {
            this.logger.debug("tryLookupAsync on collectionRid {} encountered failure", (Object)collectionRid, err);
            CosmosClientException dce = Utils.as(err, CosmosClientException.class);
            if (dce != null && Exceptions.isStatusCode(dce, 404)) {
                return Mono.empty();
            }
            return Mono.error((Throwable)err);
        });
    }

    @Override
    public Mono<CollectionRoutingMap> tryLookupAsync(String collectionRid, CollectionRoutingMap previousValue, boolean forceRefreshCollectionRoutingMap, Map<String, Object> properties) {
        return this.tryLookupAsync(collectionRid, previousValue, properties);
    }

    @Override
    public Mono<List<PartitionKeyRange>> tryGetOverlappingRangesAsync(String collectionRid, Range<String> range, boolean forceRefresh, Map<String, Object> properties) {
        Mono<CollectionRoutingMap> routingMapObs = this.tryLookupAsync(collectionRid, null, properties);
        return routingMapObs.flatMap(routingMap -> {
            if (forceRefresh) {
                this.logger.debug("tryGetOverlappingRangesAsync with forceRefresh on collectionRid {}", (Object)collectionRid);
                return this.tryLookupAsync(collectionRid, (CollectionRoutingMap)routingMap, properties);
            }
            return Mono.just((Object)routingMap);
        }).switchIfEmpty(Mono.empty()).map(routingMap -> routingMap.getOverlappingRanges(range)).switchIfEmpty(Mono.defer(() -> {
            this.logger.debug("Routing Map Null for collection: {} for range: {}, forceRefresh:{}", new Object[]{collectionRid, range.toString(), forceRefresh});
            return Mono.empty();
        }));
    }

    @Override
    public Mono<PartitionKeyRange> tryGetPartitionKeyRangeByIdAsync(String collectionResourceId, String partitionKeyRangeId, boolean forceRefresh, Map<String, Object> properties) {
        Mono<CollectionRoutingMap> routingMapObs = this.tryLookupAsync(collectionResourceId, null, properties);
        return routingMapObs.flatMap(routingMap -> {
            if (forceRefresh && routingMap != null) {
                return this.tryLookupAsync(collectionResourceId, (CollectionRoutingMap)routingMap, properties);
            }
            return Mono.justOrEmpty((Object)routingMap);
        }).switchIfEmpty(Mono.defer(Mono::empty)).map(routingMap -> routingMap.getRangeByPartitionKeyRangeId(partitionKeyRangeId)).switchIfEmpty(Mono.defer(() -> {
            this.logger.debug("Routing Map Null for collection: {}, PartitionKeyRangeId: {}, forceRefresh:{}", new Object[]{collectionResourceId, partitionKeyRangeId, forceRefresh});
            return null;
        }));
    }

    @Override
    public Mono<PartitionKeyRange> tryGetRangeByPartitionKeyRangeId(String collectionRid, String partitionKeyRangeId, Map<String, Object> properties) {
        Mono<Object> routingMapObs = this.routingMapCache.getAsync(collectionRid, null, () -> this.getRoutingMapForCollectionAsync(collectionRid, null, properties));
        return routingMapObs.map(routingMap -> routingMap.getRangeByPartitionKeyRangeId(partitionKeyRangeId)).onErrorResume(err -> {
            CosmosClientException dce = Utils.as(err, CosmosClientException.class);
            this.logger.debug("tryGetRangeByPartitionKeyRangeId on collectionRid {} and partitionKeyRangeId {} encountered failure", new Object[]{collectionRid, partitionKeyRangeId, err});
            if (dce != null && Exceptions.isStatusCode(dce, 404)) {
                return Mono.empty();
            }
            return Mono.error((Throwable)dce);
        });
    }

    private Mono<CollectionRoutingMap> getRoutingMapForCollectionAsync(String collectionRid, CollectionRoutingMap previousRoutingMap, Map<String, Object> properties) {
        Mono<List<PartitionKeyRange>> rangesObs = this.getPartitionKeyRange(collectionRid, false, properties);
        return rangesObs.flatMap(ranges -> {
            CollectionRoutingMap routingMap;
            List<ImmutablePair<PartitionKeyRange, IServerIdentity>> rangesTuples = ranges.stream().map(range -> new ImmutablePair(range, (Object)null)).collect(Collectors.toList());
            if (previousRoutingMap == null) {
                HashSet goneRanges = new HashSet(ranges.stream().flatMap(range -> CollectionUtils.emptyIfNull(range.getParents()).stream()).collect(Collectors.toSet()));
                routingMap = InMemoryCollectionRoutingMap.tryCreateCompleteRoutingMap(rangesTuples.stream().filter(tuple -> !goneRanges.contains(((PartitionKeyRange)tuple.left).getId())).collect(Collectors.toList()), collectionRid);
            } else {
                routingMap = previousRoutingMap.tryCombine(rangesTuples);
            }
            if (routingMap == null) {
                return Mono.error((Throwable)new NotFoundException(String.format("GetRoutingMapForCollectionAsync(collectionRid: {%s}), RANGE information either doesn't exist or is not complete.", collectionRid)));
            }
            return Mono.just((Object)routingMap);
        });
    }

    private Mono<List<PartitionKeyRange>> getPartitionKeyRange(String collectionRid, boolean forceRefresh, Map<String, Object> properties) {
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.ReadFeed, collectionRid, ResourceType.PartitionKeyRange, null);
        request.requestContext.resolvedCollectionRid = collectionRid;
        Mono<DocumentCollection> collectionObs = this.collectionCache.resolveCollectionAsync(request);
        return collectionObs.flatMap(coll -> {
            FeedOptions feedOptions = new FeedOptions();
            if (properties != null) {
                feedOptions.properties(properties);
            }
            return this.client.readPartitionKeyRanges(coll.getSelfLink(), feedOptions).flatMap(p -> Flux.fromIterable(p.getResults()), 1).collectList();
        });
    }
}

