/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.internal.changefeed.implementation;

import com.azure.cosmos.AccessCondition;
import com.azure.cosmos.AccessConditionType;
import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.CosmosAsyncItem;
import com.azure.cosmos.CosmosClientException;
import com.azure.cosmos.CosmosItemProperties;
import com.azure.cosmos.CosmosItemRequestOptions;
import com.azure.cosmos.internal.changefeed.ChangeFeedContextClient;
import com.azure.cosmos.internal.changefeed.LeaseStore;
import com.azure.cosmos.internal.changefeed.RequestOptionsFactory;
import com.azure.cosmos.internal.changefeed.ServiceItemLease;
import java.time.Duration;
import reactor.core.publisher.Mono;

class DocumentServiceLeaseStore
implements LeaseStore {
    private ChangeFeedContextClient client;
    private String containerNamePrefix;
    private CosmosAsyncContainer leaseCollectionLink;
    private RequestOptionsFactory requestOptionsFactory;
    private volatile String lockETag;

    public DocumentServiceLeaseStore(ChangeFeedContextClient client, String containerNamePrefix, CosmosAsyncContainer leaseCollectionLink, RequestOptionsFactory requestOptionsFactory) {
        this.client = client;
        this.containerNamePrefix = containerNamePrefix;
        this.leaseCollectionLink = leaseCollectionLink;
        this.requestOptionsFactory = requestOptionsFactory;
    }

    @Override
    public Mono<Boolean> isInitialized() {
        String markerDocId = this.getStoreMarkerName();
        CosmosItemProperties doc = new CosmosItemProperties();
        doc.setId(markerDocId);
        CosmosItemRequestOptions requestOptions = this.requestOptionsFactory.createRequestOptions(ServiceItemLease.fromDocument(doc));
        CosmosAsyncItem docItem = this.client.getContainerClient().getItem(markerDocId, "/id");
        return this.client.readItem(docItem, requestOptions).flatMap(documentResourceResponse -> Mono.just((Object)(documentResourceResponse.getItem() != null ? 1 : 0))).onErrorResume(throwable -> {
            CosmosClientException e;
            if (throwable instanceof CosmosClientException && (e = (CosmosClientException)throwable).getStatusCode() == 404) {
                return Mono.just((Object)false);
            }
            return Mono.error((Throwable)throwable);
        });
    }

    @Override
    public Mono<Boolean> markInitialized() {
        String markerDocId = this.getStoreMarkerName();
        CosmosItemProperties containerDocument = new CosmosItemProperties();
        containerDocument.setId(markerDocId);
        return this.client.createItem(this.leaseCollectionLink, containerDocument, null, false).map(item -> true).onErrorResume(throwable -> {
            CosmosClientException e;
            if (throwable instanceof CosmosClientException && (e = (CosmosClientException)throwable).getStatusCode() == 409) {
                return Mono.just((Object)true);
            }
            return Mono.just((Object)false);
        });
    }

    @Override
    public Mono<Boolean> acquireInitializationLock(Duration lockExpirationTime) {
        String lockId = this.getStoreLockName();
        CosmosItemProperties containerDocument = new CosmosItemProperties();
        containerDocument.setId(lockId);
        BridgeInternal.setProperty(containerDocument, "ttl", Long.valueOf(lockExpirationTime.getSeconds()).intValue());
        return this.client.createItem(this.leaseCollectionLink, containerDocument, null, false).map(documentResourceResponse -> {
            if (documentResourceResponse.getItem() != null) {
                this.lockETag = documentResourceResponse.getProperties().getETag();
                return true;
            }
            return false;
        }).onErrorResume(throwable -> {
            CosmosClientException e;
            if (throwable instanceof CosmosClientException && (e = (CosmosClientException)throwable).getStatusCode() == 409) {
                return Mono.just((Object)false);
            }
            return Mono.error((Throwable)throwable);
        });
    }

    @Override
    public Mono<Boolean> releaseInitializationLock() {
        String lockId = this.getStoreLockName();
        CosmosItemProperties doc = new CosmosItemProperties();
        doc.setId(lockId);
        CosmosItemRequestOptions requestOptions = this.requestOptionsFactory.createRequestOptions(ServiceItemLease.fromDocument(doc));
        if (requestOptions == null) {
            requestOptions = new CosmosItemRequestOptions();
        }
        AccessCondition accessCondition = new AccessCondition();
        accessCondition.setType(AccessConditionType.IF_MATCH);
        accessCondition.setCondition(this.lockETag);
        requestOptions.setAccessCondition(accessCondition);
        CosmosAsyncItem docItem = this.client.getContainerClient().getItem(lockId, "/id");
        return this.client.deleteItem(docItem, requestOptions).map(documentResourceResponse -> {
            if (documentResourceResponse.getItem() != null) {
                this.lockETag = null;
                return true;
            }
            return false;
        }).onErrorResume(throwable -> {
            CosmosClientException e;
            if (throwable instanceof CosmosClientException && (e = (CosmosClientException)throwable).getStatusCode() == 409) {
                return Mono.just((Object)false);
            }
            return Mono.error((Throwable)throwable);
        });
    }

    private String getStoreMarkerName() {
        return this.containerNamePrefix + ".info";
    }

    private String getStoreLockName() {
        return this.containerNamePrefix + ".lock";
    }
}

