/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.internal.changefeed.implementation;

import com.azure.cosmos.CosmosClientException;
import com.azure.cosmos.internal.changefeed.implementation.StatusCodeErrorType;

class ExceptionClassifier {
    public static final int SubStatusCode_Undefined = -1;
    public static final int SubStatusCode_PartitionKeyRangeGone = 1002;
    public static final int SubStatusCode_Splitting = 1007;
    public static final int SubStatusCode_ReadSessionNotAvailable = 1002;

    ExceptionClassifier() {
    }

    public static StatusCodeErrorType classifyClientException(CosmosClientException clientException) {
        Integer subStatusCode = clientException.getSubStatusCode();
        if (clientException.getStatusCode() == 404 && subStatusCode != 1002) {
            return StatusCodeErrorType.PARTITION_NOT_FOUND;
        }
        if (clientException.getStatusCode() == 410 && (subStatusCode == 1002 || subStatusCode == 1007)) {
            return StatusCodeErrorType.PARTITION_SPLIT;
        }
        if (clientException.getStatusCode() == 429 || clientException.getStatusCode() >= 500) {
            return StatusCodeErrorType.TRANSIENT_ERROR;
        }
        if (clientException.getMessage().contains("Reduce page size and try again.")) {
            return StatusCodeErrorType.MAX_ITEM_COUNT_TOO_LARGE;
        }
        return StatusCodeErrorType.UNDEFINED;
    }
}

