/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.internal.directconnectivity.rntbd;

import com.azure.cosmos.internal.directconnectivity.rntbd.RntbdTokenType;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.stream.Collector;

final class RntbdConstants {
    static final int CurrentProtocolVersion = 1;

    private RntbdConstants() {
    }

    static interface RntbdHeader {
        public boolean isRequired();

        public short id();

        public String name();

        public RntbdTokenType type();
    }

    public static enum RntbdResponseHeader implements RntbdHeader
    {
        PayloadPresent(0, RntbdTokenType.Byte, true),
        LastStateChangeDateTime(2, RntbdTokenType.SmallString, false),
        ContinuationToken(3, RntbdTokenType.String, false),
        ETag(4, RntbdTokenType.String, false),
        ReadsPerformed(7, RntbdTokenType.ULong, false),
        WritesPerformed(8, RntbdTokenType.ULong, false),
        QueriesPerformed(9, RntbdTokenType.ULong, false),
        IndexTermsGenerated(10, RntbdTokenType.ULong, false),
        ScriptsExecuted(11, RntbdTokenType.ULong, false),
        RetryAfterMilliseconds(12, RntbdTokenType.ULong, false),
        IndexingDirective(13, RntbdTokenType.Byte, false),
        StorageMaxResoureQuota(14, RntbdTokenType.String, false),
        StorageResourceQuotaUsage(15, RntbdTokenType.String, false),
        SchemaVersion(16, RntbdTokenType.SmallString, false),
        CollectionPartitionIndex(17, RntbdTokenType.ULong, false),
        CollectionServiceIndex(18, RntbdTokenType.ULong, false),
        LSN(19, RntbdTokenType.LongLong, false),
        ItemCount(20, RntbdTokenType.ULong, false),
        RequestCharge(21, RntbdTokenType.Double, false),
        OwnerFullName(23, RntbdTokenType.String, false),
        OwnerId(24, RntbdTokenType.String, false),
        DatabaseAccountId(25, RntbdTokenType.String, false),
        QuorumAckedLSN(26, RntbdTokenType.LongLong, false),
        RequestValidationFailure(27, RntbdTokenType.Byte, false),
        SubStatus(28, RntbdTokenType.ULong, false),
        CollectionUpdateProgress(29, RntbdTokenType.ULong, false),
        CurrentWriteQuorum(30, RntbdTokenType.ULong, false),
        CurrentReplicaSetSize(31, RntbdTokenType.ULong, false),
        CollectionLazyIndexProgress(32, RntbdTokenType.ULong, false),
        PartitionKeyRangeId(33, RntbdTokenType.String, false),
        LogResults(37, RntbdTokenType.String, false),
        XPRole(38, RntbdTokenType.ULong, false),
        IsRUPerMinuteUsed(39, RntbdTokenType.Byte, false),
        QueryMetrics(40, RntbdTokenType.String, false),
        GlobalCommittedLSN(41, RntbdTokenType.LongLong, false),
        NumberOfReadRegions(48, RntbdTokenType.ULong, false),
        OfferReplacePending(49, RntbdTokenType.Byte, false),
        ItemLSN(50, RntbdTokenType.LongLong, false),
        RestoreState(51, RntbdTokenType.String, false),
        CollectionSecurityIdentifier(52, RntbdTokenType.String, false),
        TransportRequestID(53, RntbdTokenType.ULong, false),
        ShareThroughput(54, RntbdTokenType.Byte, false),
        DisableRntbdChannel(56, RntbdTokenType.Byte, false),
        ServerDateTimeUtc(57, RntbdTokenType.SmallString, false),
        LocalLSN(58, RntbdTokenType.LongLong, false),
        QuorumAckedLocalLSN(59, RntbdTokenType.LongLong, false),
        ItemLocalLSN(60, RntbdTokenType.LongLong, false),
        HasTentativeWrites(61, RntbdTokenType.Byte, false),
        SessionToken(62, RntbdTokenType.String, false);

        public static final ImmutableMap<Short, RntbdResponseHeader> map;
        public static final ImmutableSet<RntbdResponseHeader> set;
        private final short id;
        private final boolean isRequired;
        private final RntbdTokenType type;

        private RntbdResponseHeader(short id, RntbdTokenType type, boolean isRequired) {
            this.id = id;
            this.type = type;
            this.isRequired = isRequired;
        }

        @Override
        public boolean isRequired() {
            return this.isRequired;
        }

        @Override
        public short id() {
            return this.id;
        }

        @Override
        public RntbdTokenType type() {
            return this.type;
        }

        static {
            set = Sets.immutableEnumSet(EnumSet.allOf(RntbdResponseHeader.class));
            Collector collector = ImmutableMap.toImmutableMap(RntbdResponseHeader::id, header -> header);
            map = (ImmutableMap)set.stream().collect(collector);
        }
    }

    static enum RntbdResourceType {
        Connection(0),
        Database(1),
        Collection(2),
        Document(3),
        Attachment(4),
        User(5),
        Permission(6),
        StoredProcedure(7),
        Conflict(8),
        Trigger(9),
        UserDefinedFunction(10),
        Module(11),
        Replica(12),
        ModuleCommand(13),
        Record(14),
        Offer(15),
        PartitionSetInformation(16),
        XPReplicatorAddress(17),
        MasterPartition(18),
        ServerPartition(19),
        DatabaseAccount(20),
        Topology(21),
        PartitionKeyRange(22),
        Schema(24),
        BatchApply(25),
        RestoreMetadata(26),
        ComputeGatewayCharges(27),
        RidRange(28),
        UserDefinedType(29);

        private final short id;

        private RntbdResourceType(short id) {
            this.id = id;
        }

        public static RntbdResourceType fromId(short id) throws IllegalArgumentException {
            switch (id) {
                case 0: {
                    return Connection;
                }
                case 1: {
                    return Database;
                }
                case 2: {
                    return Collection;
                }
                case 3: {
                    return Document;
                }
                case 4: {
                    return Attachment;
                }
                case 5: {
                    return User;
                }
                case 6: {
                    return Permission;
                }
                case 7: {
                    return StoredProcedure;
                }
                case 8: {
                    return Conflict;
                }
                case 9: {
                    return Trigger;
                }
                case 10: {
                    return UserDefinedFunction;
                }
                case 11: {
                    return Module;
                }
                case 12: {
                    return Replica;
                }
                case 13: {
                    return ModuleCommand;
                }
                case 14: {
                    return Record;
                }
                case 15: {
                    return Offer;
                }
                case 16: {
                    return PartitionSetInformation;
                }
                case 17: {
                    return XPReplicatorAddress;
                }
                case 18: {
                    return MasterPartition;
                }
                case 19: {
                    return ServerPartition;
                }
                case 20: {
                    return DatabaseAccount;
                }
                case 21: {
                    return Topology;
                }
                case 22: {
                    return PartitionKeyRange;
                }
                case 24: {
                    return Schema;
                }
                case 25: {
                    return BatchApply;
                }
                case 26: {
                    return RestoreMetadata;
                }
                case 27: {
                    return ComputeGatewayCharges;
                }
                case 28: {
                    return RidRange;
                }
                case 29: {
                    return UserDefinedType;
                }
            }
            throw new IllegalArgumentException(Strings.lenientFormat((String)"id: %s", (Object[])new Object[]{id}));
        }

        public short id() {
            return this.id;
        }
    }

    public static enum RntbdRequestHeader implements RntbdHeader
    {
        ResourceId(0, RntbdTokenType.Bytes, false),
        AuthorizationToken(1, RntbdTokenType.String, false),
        PayloadPresent(2, RntbdTokenType.Byte, true),
        Date(3, RntbdTokenType.SmallString, false),
        PageSize(4, RntbdTokenType.ULong, false),
        SessionToken(5, RntbdTokenType.String, false),
        ContinuationToken(6, RntbdTokenType.String, false),
        IndexingDirective(7, RntbdTokenType.Byte, false),
        Match(8, RntbdTokenType.String, false),
        PreTriggerInclude(9, RntbdTokenType.String, false),
        PostTriggerInclude(10, RntbdTokenType.String, false),
        IsFanout(11, RntbdTokenType.Byte, false),
        CollectionPartitionIndex(12, RntbdTokenType.ULong, false),
        CollectionServiceIndex(13, RntbdTokenType.ULong, false),
        PreTriggerExclude(14, RntbdTokenType.String, false),
        PostTriggerExclude(15, RntbdTokenType.String, false),
        ConsistencyLevel(16, RntbdTokenType.Byte, false),
        EntityId(17, RntbdTokenType.String, false),
        ResourceSchemaName(18, RntbdTokenType.SmallString, false),
        ReplicaPath(19, RntbdTokenType.String, true),
        ResourceTokenExpiry(20, RntbdTokenType.ULong, false),
        DatabaseName(21, RntbdTokenType.String, false),
        CollectionName(22, RntbdTokenType.String, false),
        DocumentName(23, RntbdTokenType.String, false),
        AttachmentName(24, RntbdTokenType.String, false),
        UserName(25, RntbdTokenType.String, false),
        PermissionName(26, RntbdTokenType.String, false),
        StoredProcedureName(27, RntbdTokenType.String, false),
        UserDefinedFunctionName(28, RntbdTokenType.String, false),
        TriggerName(29, RntbdTokenType.String, false),
        EnableScanInQuery(30, RntbdTokenType.Byte, false),
        EmitVerboseTracesInQuery(31, RntbdTokenType.Byte, false),
        ConflictName(32, RntbdTokenType.String, false),
        BindReplicaDirective(33, RntbdTokenType.String, false),
        PrimaryMasterKey(34, RntbdTokenType.String, false),
        SecondaryMasterKey(35, RntbdTokenType.String, false),
        PrimaryReadonlyKey(36, RntbdTokenType.String, false),
        SecondaryReadonlyKey(37, RntbdTokenType.String, false),
        ProfileRequest(38, RntbdTokenType.Byte, false),
        EnableLowPrecisionOrderBy(39, RntbdTokenType.Byte, false),
        ClientVersion(40, RntbdTokenType.SmallString, false),
        CanCharge(41, RntbdTokenType.Byte, false),
        CanThrottle(42, RntbdTokenType.Byte, false),
        PartitionKey(43, RntbdTokenType.String, false),
        PartitionKeyRangeId(44, RntbdTokenType.String, false),
        NotUsed2D(45, RntbdTokenType.Invalid, false),
        NotUsed2E(46, RntbdTokenType.Invalid, false),
        NotUsed2F(47, RntbdTokenType.Invalid, false),
        MigrateCollectionDirective(49, RntbdTokenType.Byte, false),
        NotUsed32(50, RntbdTokenType.Invalid, false),
        SupportSpatialLegacyCoordinates(51, RntbdTokenType.Byte, false),
        PartitionCount(52, RntbdTokenType.ULong, false),
        CollectionRid(53, RntbdTokenType.String, false),
        PartitionKeyRangeName(54, RntbdTokenType.String, false),
        SchemaName(58, RntbdTokenType.String, false),
        FilterBySchemaRid(59, RntbdTokenType.String, false),
        UsePolygonsSmallerThanAHemisphere(60, RntbdTokenType.Byte, false),
        GatewaySignature(61, RntbdTokenType.String, false),
        EnableLogging(62, RntbdTokenType.Byte, false),
        A_IM(63, RntbdTokenType.String, false),
        PopulateQuotaInfo(64, RntbdTokenType.Byte, false),
        DisableRUPerMinuteUsage(65, RntbdTokenType.Byte, false),
        PopulateQueryMetrics(66, RntbdTokenType.Byte, false),
        ResponseContinuationTokenLimitInKb(67, RntbdTokenType.ULong, false),
        PopulatePartitionStatistics(68, RntbdTokenType.Byte, false),
        RemoteStorageType(69, RntbdTokenType.Byte, false),
        CollectionRemoteStorageSecurityIdentifier(70, RntbdTokenType.String, false),
        IfModifiedSince(71, RntbdTokenType.String, false),
        PopulateCollectionThroughputInfo(72, RntbdTokenType.Byte, false),
        RemainingTimeInMsOnClientRequest(73, RntbdTokenType.ULong, false),
        ClientRetryAttemptCount(74, RntbdTokenType.ULong, false),
        TargetLsn(75, RntbdTokenType.LongLong, false),
        TargetGlobalCommittedLsn(76, RntbdTokenType.LongLong, false),
        TransportRequestID(77, RntbdTokenType.ULong, false),
        RestoreMetadaFilter(78, RntbdTokenType.String, false),
        RestoreParams(79, RntbdTokenType.String, false),
        ShareThroughput(80, RntbdTokenType.Byte, false),
        PartitionResourceFilter(81, RntbdTokenType.String, false),
        IsReadOnlyScript(82, RntbdTokenType.Byte, false),
        IsAutoScaleRequest(83, RntbdTokenType.Byte, false),
        ForceQueryScan(84, RntbdTokenType.Byte, false),
        CanOfferReplaceComplete(86, RntbdTokenType.Byte, false),
        ExcludeSystemProperties(87, RntbdTokenType.Byte, false),
        BinaryId(88, RntbdTokenType.Bytes, false),
        TimeToLiveInSeconds(89, RntbdTokenType.Long, false),
        EffectivePartitionKey(90, RntbdTokenType.Bytes, false),
        BinaryPassthroughRequest(91, RntbdTokenType.Byte, false),
        UserDefinedTypeName(92, RntbdTokenType.String, false),
        EnableDynamicRidRangeAllocation(93, RntbdTokenType.Byte, false),
        EnumerationDirection(94, RntbdTokenType.Byte, false),
        StartId(95, RntbdTokenType.Bytes, false),
        EndId(96, RntbdTokenType.Bytes, false),
        FanoutOperationState(97, RntbdTokenType.Byte, false),
        StartEpk(98, RntbdTokenType.Bytes, false),
        EndEpk(99, RntbdTokenType.Bytes, false),
        ReadFeedKeyType(100, RntbdTokenType.Byte, false),
        ContentSerializationFormat(101, RntbdTokenType.Byte, false),
        AllowTentativeWrites(102, RntbdTokenType.Byte, false),
        IsUserRequest(103, RntbdTokenType.Byte, false),
        SharedOfferThroughput(104, RntbdTokenType.ULong, false);

        public static final ImmutableMap<Short, RntbdRequestHeader> map;
        public static final ImmutableSet<RntbdRequestHeader> set;
        private final short id;
        private final boolean isRequired;
        private final RntbdTokenType type;

        private RntbdRequestHeader(short id, RntbdTokenType type, boolean isRequired) {
            this.id = id;
            this.type = type;
            this.isRequired = isRequired;
        }

        @Override
        public boolean isRequired() {
            return this.isRequired;
        }

        @Override
        public short id() {
            return this.id;
        }

        @Override
        public RntbdTokenType type() {
            return this.type;
        }

        static {
            set = Sets.immutableEnumSet(EnumSet.allOf(RntbdRequestHeader.class));
            Collector collector = ImmutableMap.toImmutableMap(RntbdRequestHeader::id, h -> h);
            map = (ImmutableMap)set.stream().collect(collector);
        }
    }

    public static enum RntbdRemoteStorageType {
        Invalid(0),
        NotSpecified(1),
        Standard(2),
        Premium(3);

        private final byte id;

        private RntbdRemoteStorageType(byte id) {
            this.id = id;
        }

        public byte id() {
            return this.id;
        }
    }

    public static enum RntbdReadFeedKeyType {
        Invalid(0),
        ResourceId(1),
        EffectivePartitionKey(2);

        private final byte id;

        private RntbdReadFeedKeyType(byte id) {
            this.id = id;
        }

        public byte id() {
            return this.id;
        }
    }

    static enum RntbdOperationType {
        Connection(0),
        Create(1),
        Update(2),
        Read(3),
        ReadFeed(4),
        Delete(5),
        Replace(6),
        ExecuteJavaScript(8),
        SQLQuery(9),
        Pause(10),
        Resume(11),
        Stop(12),
        Recycle(13),
        Crash(14),
        Query(15),
        ForceConfigRefresh(16),
        Head(17),
        HeadFeed(18),
        Upsert(19),
        Recreate(20),
        Throttle(21),
        GetSplitPoint(22),
        PreCreateValidation(23),
        BatchApply(24),
        AbortSplit(25),
        CompleteSplit(26),
        OfferUpdateOperation(27),
        OfferPreGrowValidation(28),
        BatchReportThroughputUtilization(29),
        CompletePartitionMigration(30),
        AbortPartitionMigration(31),
        PreReplaceValidation(32),
        AddComputeGatewayRequestCharges(33),
        MigratePartition(34);

        private final short id;

        private RntbdOperationType(short id) {
            this.id = id;
        }

        public static RntbdOperationType fromId(short id) throws IllegalArgumentException {
            switch (id) {
                case 0: {
                    return Connection;
                }
                case 1: {
                    return Create;
                }
                case 2: {
                    return Update;
                }
                case 3: {
                    return Read;
                }
                case 4: {
                    return ReadFeed;
                }
                case 5: {
                    return Delete;
                }
                case 6: {
                    return Replace;
                }
                case 8: {
                    return ExecuteJavaScript;
                }
                case 9: {
                    return SQLQuery;
                }
                case 10: {
                    return Pause;
                }
                case 11: {
                    return Resume;
                }
                case 12: {
                    return Stop;
                }
                case 13: {
                    return Recycle;
                }
                case 14: {
                    return Crash;
                }
                case 15: {
                    return Query;
                }
                case 16: {
                    return ForceConfigRefresh;
                }
                case 17: {
                    return Head;
                }
                case 18: {
                    return HeadFeed;
                }
                case 19: {
                    return Upsert;
                }
                case 20: {
                    return Recreate;
                }
                case 21: {
                    return Throttle;
                }
                case 22: {
                    return GetSplitPoint;
                }
                case 23: {
                    return PreCreateValidation;
                }
                case 24: {
                    return BatchApply;
                }
                case 25: {
                    return AbortSplit;
                }
                case 26: {
                    return CompleteSplit;
                }
                case 27: {
                    return OfferUpdateOperation;
                }
                case 28: {
                    return OfferPreGrowValidation;
                }
                case 29: {
                    return BatchReportThroughputUtilization;
                }
                case 30: {
                    return CompletePartitionMigration;
                }
                case 31: {
                    return AbortPartitionMigration;
                }
                case 32: {
                    return PreReplaceValidation;
                }
                case 33: {
                    return AddComputeGatewayRequestCharges;
                }
                case 34: {
                    return MigratePartition;
                }
            }
            throw new IllegalArgumentException("id");
        }

        public short id() {
            return this.id;
        }
    }

    public static enum RntbdMigrateCollectionDirective {
        Thaw(0),
        Freeze(1),
        Invalid(-1);

        private final byte id;

        private RntbdMigrateCollectionDirective(byte id) {
            this.id = id;
        }

        public byte id() {
            return this.id;
        }
    }

    static enum RntbdIndexingDirective {
        Default(0),
        Include(1),
        Exclude(2),
        Invalid(-1);

        private final byte id;

        private RntbdIndexingDirective(byte id) {
            this.id = id;
        }

        public static RntbdIndexingDirective fromId(byte id) {
            switch (id) {
                case 0: {
                    return Default;
                }
                case 1: {
                    return Include;
                }
                case 2: {
                    return Exclude;
                }
                case -1: {
                    return Invalid;
                }
            }
            throw new IllegalArgumentException("id");
        }

        public byte id() {
            return this.id;
        }
    }

    public static enum RntbdFanoutOperationState {
        Started(1),
        Completed(2);

        private final byte id;

        private RntbdFanoutOperationState(byte id) {
            this.id = id;
        }

        public byte id() {
            return this.id;
        }
    }

    public static enum RntbdEnumerationDirection {
        Invalid(0),
        Forward(1),
        Reverse(2);

        private final byte id;

        private RntbdEnumerationDirection(byte id) {
            this.id = id;
        }

        public byte id() {
            return this.id;
        }
    }

    static enum RntbdContextRequestHeader implements RntbdHeader
    {
        ProtocolVersion(0, RntbdTokenType.ULong, true),
        ClientVersion(1, RntbdTokenType.SmallString, true),
        UserAgent(2, RntbdTokenType.SmallString, true);

        public static final ImmutableMap<Short, RntbdContextRequestHeader> map;
        public static final ImmutableSet<RntbdContextRequestHeader> set;
        private final short id;
        private final boolean isRequired;
        private final RntbdTokenType type;

        private RntbdContextRequestHeader(short id, RntbdTokenType type, boolean isRequired) {
            this.id = id;
            this.type = type;
            this.isRequired = isRequired;
        }

        @Override
        public boolean isRequired() {
            return this.isRequired;
        }

        @Override
        public short id() {
            return this.id;
        }

        @Override
        public RntbdTokenType type() {
            return this.type;
        }

        static {
            set = Sets.immutableEnumSet(EnumSet.allOf(RntbdContextRequestHeader.class));
            Collector collector = ImmutableMap.toImmutableMap(h -> h.id(), h -> h);
            map = (ImmutableMap)set.stream().collect(collector);
        }
    }

    static enum RntbdContextHeader implements RntbdHeader
    {
        ProtocolVersion(0, RntbdTokenType.ULong, false),
        ClientVersion(1, RntbdTokenType.SmallString, false),
        ServerAgent(2, RntbdTokenType.SmallString, true),
        ServerVersion(3, RntbdTokenType.SmallString, true),
        IdleTimeoutInSeconds(4, RntbdTokenType.ULong, false),
        UnauthenticatedTimeoutInSeconds(5, RntbdTokenType.ULong, false);

        public static final ImmutableMap<Short, RntbdContextHeader> map;
        public static final ImmutableSet<RntbdContextHeader> set;
        private final short id;
        private final boolean isRequired;
        private final RntbdTokenType type;

        private RntbdContextHeader(short id, RntbdTokenType type, boolean isRequired) {
            this.id = id;
            this.type = type;
            this.isRequired = isRequired;
        }

        @Override
        public boolean isRequired() {
            return this.isRequired;
        }

        @Override
        public short id() {
            return this.id;
        }

        @Override
        public RntbdTokenType type() {
            return this.type;
        }

        static {
            set = Sets.immutableEnumSet(EnumSet.allOf(RntbdContextHeader.class));
            Collector collector = ImmutableMap.toImmutableMap(RntbdContextHeader::id, h -> h);
            map = (ImmutableMap)set.stream().collect(collector);
        }
    }

    public static enum RntbdContentSerializationFormat {
        JsonText(0),
        CosmosBinary(1),
        Invalid(-1);

        private final byte id;

        private RntbdContentSerializationFormat(byte id) {
            this.id = id;
        }

        public byte id() {
            return this.id;
        }
    }

    public static enum RntbdConsistencyLevel {
        Strong(0),
        BoundedStaleness(1),
        Session(2),
        Eventual(3),
        ConsistentPrefix(4),
        Invalid(-1);

        private final byte id;

        private RntbdConsistencyLevel(byte id) {
            this.id = id;
        }

        public byte id() {
            return this.id;
        }
    }
}

