/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.internal.directconnectivity.rntbd;

import com.azure.cosmos.internal.directconnectivity.rntbd.RntbdContextRequest;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;

public class RntbdContextRequestDecoder
extends ByteToMessageDecoder {
    public RntbdContextRequestDecoder() {
        this.setSingleDecode(true);
    }

    public void channelRead(ChannelHandlerContext context, Object message) throws Exception {
        ByteBuf in;
        int resourceOperationType;
        if (message instanceof ByteBuf && (resourceOperationType = (in = (ByteBuf)message).getInt(in.readerIndex() + 4)) == 0) {
            assert (this.isSingleDecode());
            super.channelRead(context, message);
            return;
        }
        context.fireChannelRead(message);
    }

    protected void decode(ChannelHandlerContext context, ByteBuf in, List<Object> out) throws IllegalStateException {
        RntbdContextRequest request;
        in.markReaderIndex();
        try {
            request = RntbdContextRequest.decode(in);
        }
        catch (IllegalStateException error) {
            in.resetReaderIndex();
            throw error;
        }
        in.discardReadBytes();
        out.add(request);
    }
}

