/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.internal.directconnectivity.rntbd;

import com.azure.cosmos.internal.directconnectivity.RntbdTransportClient;
import com.azure.cosmos.internal.directconnectivity.rntbd.RntbdEndpoint;
import com.azure.cosmos.internal.directconnectivity.rntbd.RntbdObjectMapper;
import com.azure.cosmos.internal.directconnectivity.rntbd.RntbdRequestRecord;
import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.net.PercentEscaper;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.dropwizard.DropwizardConfig;
import io.micrometer.core.instrument.dropwizard.DropwizardMeterRegistry;
import io.micrometer.core.instrument.util.HierarchicalNameMapper;
import io.micrometer.core.lang.Nullable;
import java.util.concurrent.TimeUnit;

@JsonPropertyOrder(value={"tags", "concurrentRequests", "requests", "responseErrors", "responseSuccesses", "completionRate", "responseRate", "channelsAcquired", "channelsAvailable", "requestQueueLength", "usedDirectMemory", "usedHeapMemory"})
public final class RntbdMetrics {
    private static final PercentEscaper escaper = new PercentEscaper("_-", false);
    private static final CompositeMeterRegistry registry = new CompositeMeterRegistry();
    private static final String prefix = "azure.cosmos.directTcp.";
    private static MeterRegistry consoleLoggingRegistry;
    private final RntbdTransportClient transportClient;
    private final RntbdEndpoint endpoint;
    private final Timer requests;
    private final Timer responseErrors;
    private final Timer responseSuccesses;
    private final Tags tags;

    public RntbdMetrics(RntbdTransportClient client, RntbdEndpoint endpoint) {
        this.transportClient = client;
        this.endpoint = endpoint;
        this.tags = Tags.of((Tag[])new Tag[]{client.tag(), endpoint.tag()});
        this.requests = registry.timer(RntbdMetrics.nameOf("requests"), (Iterable)this.tags);
        this.responseErrors = registry.timer(RntbdMetrics.nameOf("responseErrors"), (Iterable)this.tags);
        this.responseSuccesses = registry.timer(RntbdMetrics.nameOf("responseSuccesses"), (Iterable)this.tags);
        Gauge.builder((String)RntbdMetrics.nameOf("endpoints"), (Object)client, RntbdTransportClient::endpointCount).description("endpoint count").tag(client.tag().getKey(), client.tag().getValue()).register((MeterRegistry)registry);
        Gauge.builder((String)RntbdMetrics.nameOf("endpointsEvicted"), (Object)client, RntbdTransportClient::endpointEvictionCount).description("endpoint eviction count").tag(client.tag().getKey(), client.tag().getValue()).register((MeterRegistry)registry);
        Gauge.builder((String)RntbdMetrics.nameOf("concurrentRequests"), (Object)endpoint, RntbdEndpoint::concurrentRequests).description("executing or queued request count").tags((Iterable)this.tags).register((MeterRegistry)registry);
        Gauge.builder((String)RntbdMetrics.nameOf("requestQueueLength"), (Object)endpoint, RntbdEndpoint::requestQueueLength).description("queued request count").tags((Iterable)this.tags).register((MeterRegistry)registry);
        Gauge.builder((String)RntbdMetrics.nameOf("channelsAcquired"), (Object)endpoint, RntbdEndpoint::channelsAcquired).description("acquired channel count").tags((Iterable)this.tags).register((MeterRegistry)registry);
        Gauge.builder((String)RntbdMetrics.nameOf("channelsAvailable"), (Object)endpoint, RntbdEndpoint::channelsAvailable).description("available channel count").tags((Iterable)this.tags).register((MeterRegistry)registry);
        Gauge.builder((String)RntbdMetrics.nameOf("usedDirectMemory"), (Object)endpoint, x -> x.usedDirectMemory()).description("Java direct memory usage").baseUnit("bytes").tags((Iterable)this.tags).register((MeterRegistry)registry);
        Gauge.builder((String)RntbdMetrics.nameOf("usedHeapMemory"), (Object)endpoint, x -> x.usedHeapMemory()).description("Java heap memory usage").baseUnit("MiB").tags((Iterable)this.tags).register((MeterRegistry)registry);
    }

    @JsonIgnore
    private static synchronized MeterRegistry consoleLoggingRegistry(int step) {
        if (consoleLoggingRegistry == null) {
            MetricRegistry dropwizardRegistry = new MetricRegistry();
            ConsoleReporter consoleReporter = ConsoleReporter.forRegistry((MetricRegistry)dropwizardRegistry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
            consoleReporter.start((long)step, TimeUnit.SECONDS);
            DropwizardConfig dropwizardConfig = new DropwizardConfig(){

                public String get(@Nullable String key) {
                    return null;
                }

                public String prefix() {
                    return "console";
                }
            };
            consoleLoggingRegistry = new DropwizardMeterRegistry(dropwizardConfig, dropwizardRegistry, HierarchicalNameMapper.DEFAULT, Clock.SYSTEM){

                @Nullable
                protected Double nullGaugeValue() {
                    return null;
                }
            };
            consoleLoggingRegistry.config().namingConvention(NamingConvention.dot);
        }
        return consoleLoggingRegistry;
    }

    @JsonProperty
    public int channelsAcquired() {
        return this.endpoint.channelsAcquired();
    }

    @JsonProperty
    public int channelsAvailable() {
        return this.endpoint.channelsAvailable();
    }

    @JsonProperty
    public double completionRate() {
        return (double)this.responseSuccesses.count() / (double)this.requests.count();
    }

    @JsonProperty
    public long concurrentRequests() {
        return this.endpoint.concurrentRequests();
    }

    @JsonProperty
    public int endpoints() {
        return this.transportClient.endpointCount();
    }

    @JsonProperty
    public int requestQueueLength() {
        return this.endpoint.requestQueueLength();
    }

    @JsonProperty
    public Iterable<Measurement> requests() {
        return this.requests.measure();
    }

    @JsonProperty
    public Iterable<Measurement> responseErrors() {
        return this.responseErrors.measure();
    }

    @JsonProperty
    public double responseRate() {
        return (double)this.responseSuccesses.count() / (double)(this.requests.count() + (long)this.endpoint.concurrentRequests());
    }

    @JsonProperty
    public Iterable<Measurement> responseSuccesses() {
        return this.responseSuccesses.measure();
    }

    @JsonProperty
    public Iterable<Tag> tags() {
        return this.tags;
    }

    @JsonProperty
    public long usedDirectMemory() {
        return this.endpoint.usedDirectMemory();
    }

    @JsonProperty
    public long usedHeapMemory() {
        return this.endpoint.usedHeapMemory();
    }

    public static void add(MeterRegistry registry) {
        RntbdMetrics.registry.add(registry);
    }

    public void markComplete(RntbdRequestRecord record) {
        record.stop(this.requests, record.isCompletedExceptionally() ? this.responseErrors : this.responseSuccesses);
    }

    public static String escape(String value) {
        return escaper.escape(value);
    }

    public String toString() {
        return RntbdObjectMapper.toString(this);
    }

    private static String nameOf(String member) {
        return prefix + member;
    }

    static {
        int step = Integer.getInteger("azure.cosmos.monitoring.consoleLogging.step", 0);
        if (step > 0) {
            RntbdMetrics.add(RntbdMetrics.consoleLoggingRegistry(step));
        }
    }
}

