/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.internal.query;

import com.azure.cosmos.FeedOptions;
import com.azure.cosmos.FeedResponse;
import com.azure.cosmos.Resource;
import com.azure.cosmos.SqlQuerySpec;
import com.azure.cosmos.internal.PartitionKeyRange;
import com.azure.cosmos.internal.ResourceType;
import com.azure.cosmos.internal.Utils;
import com.azure.cosmos.internal.query.AggregateDocumentQueryExecutionContext;
import com.azure.cosmos.internal.query.IDocumentQueryClient;
import com.azure.cosmos.internal.query.IDocumentQueryExecutionComponent;
import com.azure.cosmos.internal.query.IDocumentQueryExecutionContext;
import com.azure.cosmos.internal.query.OrderByDocumentQueryExecutionContext;
import com.azure.cosmos.internal.query.ParallelDocumentQueryExecutionContext;
import com.azure.cosmos.internal.query.PartitionedQueryExecutionInfo;
import com.azure.cosmos.internal.query.QueryInfo;
import com.azure.cosmos.internal.query.TopDocumentQueryExecutionContext;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import reactor.core.publisher.Flux;

public class PipelinedDocumentQueryExecutionContext<T extends Resource>
implements IDocumentQueryExecutionContext<T> {
    private IDocumentQueryExecutionComponent<T> component;
    private int actualPageSize;
    private UUID correlatedActivityId;

    private PipelinedDocumentQueryExecutionContext(IDocumentQueryExecutionComponent<T> component, int actualPageSize, UUID correlatedActivityId) {
        this.component = component;
        this.actualPageSize = actualPageSize;
        this.correlatedActivityId = correlatedActivityId;
    }

    public static <T extends Resource> Flux<PipelinedDocumentQueryExecutionContext<T>> createAsync(IDocumentQueryClient client, ResourceType resourceTypeEnum, Class<T> resourceType, SqlQuerySpec expression, FeedOptions feedOptions, String resourceLink, String collectionRid, PartitionedQueryExecutionInfo partitionedQueryExecutionInfo, List<PartitionKeyRange> targetRanges, int initialPageSize, boolean isContinuationExpected, boolean getLazyFeedResponse, UUID correlatedActivityId) {
        QueryInfo queryInfo = partitionedQueryExecutionInfo.getQueryInfo();
        Function<String, Flux> createBaseComponentFunction = queryInfo.hasOrderBy() ? continuationToken -> {
            FeedOptions orderByFeedOptions = new FeedOptions(feedOptions);
            orderByFeedOptions.requestContinuation((String)continuationToken);
            return OrderByDocumentQueryExecutionContext.createAsync(client, resourceTypeEnum, resourceType, expression, orderByFeedOptions, resourceLink, collectionRid, partitionedQueryExecutionInfo, targetRanges, initialPageSize, isContinuationExpected, getLazyFeedResponse, correlatedActivityId);
        } : continuationToken -> {
            FeedOptions parallelFeedOptions = new FeedOptions(feedOptions);
            parallelFeedOptions.requestContinuation((String)continuationToken);
            return ParallelDocumentQueryExecutionContext.createAsync(client, resourceTypeEnum, resourceType, expression, parallelFeedOptions, resourceLink, collectionRid, partitionedQueryExecutionInfo, targetRanges, initialPageSize, isContinuationExpected, getLazyFeedResponse, correlatedActivityId);
        };
        Function<String, Flux> createAggregateComponentFunction = queryInfo.hasAggregates() ? continuationToken -> AggregateDocumentQueryExecutionContext.createAsync(createBaseComponentFunction, queryInfo.getAggregates(), continuationToken) : createBaseComponentFunction;
        Function<String, Flux> createTopComponentFunction = queryInfo.hasTop() ? continuationToken -> TopDocumentQueryExecutionContext.createAsync(createAggregateComponentFunction, queryInfo.getTop(), continuationToken) : createAggregateComponentFunction;
        int actualPageSize = Utils.getValueOrDefault(feedOptions.maxItemCount(), 100);
        if (actualPageSize == -1) {
            actualPageSize = Integer.MAX_VALUE;
        }
        int pageSize = Math.min(actualPageSize, Utils.getValueOrDefault(queryInfo.getTop(), actualPageSize));
        return createTopComponentFunction.apply(feedOptions.requestContinuation()).map(c -> new PipelinedDocumentQueryExecutionContext(c, pageSize, correlatedActivityId));
    }

    @Override
    public Flux<FeedResponse<T>> executeAsync() {
        return this.component.drainAsync(this.actualPageSize);
    }
}

