/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosClientException;
import com.azure.cosmos.CosmosError;
import com.azure.cosmos.implementation.directconnectivity.HttpUtils;
import com.azure.cosmos.implementation.http.HttpHeaders;
import java.util.Map;

public class ConflictException
extends CosmosClientException {
    private static final long serialVersionUID = 1L;

    ConflictException() {
        this("Entity with the specified id already exists in the system.");
    }

    public ConflictException(CosmosError cosmosError, long lsn, String partitionKeyRangeId, Map<String, String> responseHeaders) {
        super(409, cosmosError, responseHeaders);
        BridgeInternal.setLSN(this, lsn);
        BridgeInternal.setPartitionKeyRangeId(this, partitionKeyRangeId);
    }

    ConflictException(String msg) {
        super(409, msg);
    }

    ConflictException(String msg, String resourceAddress) {
        super(msg, null, null, 409, resourceAddress);
    }

    public ConflictException(String message, HttpHeaders headers, String requestUriString) {
        this(message, null, headers, requestUriString);
    }

    ConflictException(Exception innerException) {
        this("Entity with the specified id already exists in the system.", innerException, null, null);
    }

    ConflictException(CosmosError cosmosError, Map<String, String> headers) {
        super(409, cosmosError, headers);
    }

    ConflictException(String message, Exception innerException, HttpHeaders headers, String requestUriString) {
        super(String.format("%s: %s", "Entity with the specified id already exists in the system.", message), innerException, HttpUtils.asMap(headers), 409, requestUriString);
    }
}

