/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import java.util.HashMap;
import java.util.Map;

public enum ConsistencyLevel {
    STRONG("Strong"),
    BOUNDED_STALENESS("BoundedStaleness"),
    SESSION("Session"),
    EVENTUAL("Eventual"),
    CONSISTENT_PREFIX("ConsistentPrefix");

    private final String overWireValue;
    private static Map<String, ConsistencyLevel> consistencyLevelHashMap;

    private ConsistencyLevel(String overWireValue) {
        this.overWireValue = overWireValue;
    }

    public String toString() {
        return this.overWireValue;
    }

    public static ConsistencyLevel fromServiceSerializedFormat(String consistencyLevel) {
        return consistencyLevelHashMap.get(consistencyLevel);
    }

    static {
        consistencyLevelHashMap = new HashMap<String, ConsistencyLevel>();
        for (ConsistencyLevel cl : ConsistencyLevel.values()) {
            consistencyLevelHashMap.put(cl.toString(), cl);
        }
    }
}

