/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.core.util.IterableStream;
import com.azure.core.util.paging.ContinuablePage;
import com.azure.core.util.paging.ContinuablePagedFlux;
import java.util.stream.Stream;

public abstract class ContinuablePagedIterable<C, T, P extends ContinuablePage<C, T>>
extends IterableStream<T> {
    private final int DEFAULT_BATCH_SIZE;
    private final ContinuablePagedFlux<C, T, P> pagedFlux;

    public ContinuablePagedIterable(ContinuablePagedFlux<C, T, P> pagedFlux) {
        super(pagedFlux);
        this.pagedFlux = pagedFlux;
        this.DEFAULT_BATCH_SIZE = 1;
    }

    public ContinuablePagedIterable(ContinuablePagedFlux<C, T, P> pagedFlux, int batchSize) {
        super(pagedFlux);
        this.pagedFlux = pagedFlux;
        this.DEFAULT_BATCH_SIZE = batchSize;
    }

    public Stream<P> streamByPage() {
        return this.pagedFlux.byPage().toStream(this.DEFAULT_BATCH_SIZE);
    }

    public Stream<P> streamByPage(C continuationToken) {
        return this.pagedFlux.byPage(continuationToken).toStream(this.DEFAULT_BATCH_SIZE);
    }

    public Stream<P> streamByPage(int preferredPageSize) {
        return this.pagedFlux.byPage(null, preferredPageSize).toStream(this.DEFAULT_BATCH_SIZE);
    }

    public Stream<P> streamByPage(C continuationToken, int preferredPageSize) {
        return this.pagedFlux.byPage(continuationToken, preferredPageSize).toStream(this.DEFAULT_BATCH_SIZE);
    }

    public Iterable<P> iterableByPage() {
        return this.pagedFlux.byPage().toIterable(this.DEFAULT_BATCH_SIZE);
    }

    public Iterable<P> iterableByPage(C continuationToken) {
        return this.pagedFlux.byPage(continuationToken).toIterable(this.DEFAULT_BATCH_SIZE);
    }

    public Iterable<P> iterableByPage(int preferredPageSize) {
        return this.pagedFlux.byPage(null, preferredPageSize).toIterable(this.DEFAULT_BATCH_SIZE);
    }

    public Iterable<P> iterableByPage(C continuationToken, int preferredPageSize) {
        return this.pagedFlux.byPage(continuationToken, preferredPageSize).toIterable(this.DEFAULT_BATCH_SIZE);
    }
}

